/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IsSameDatePart
extends TypeSafeDiagnosingMatcher<Date> {
    private final int datePart;
    private final int expected;
    private final String datePartLabel;
    private final String dateFormat;
    private final String expectedValueDescription;

    public IsSameDatePart(int expectedValue, String expectedValueDescription, int datePart, String label, String format) {
        this.datePart = datePart;
        this.expected = expectedValue;
        this.expectedValueDescription = expectedValueDescription;
        this.datePartLabel = label;
        this.dateFormat = format;
    }

    public IsSameDatePart(Date date, int datePart, String datePartLabel, String format) {
        this(IsSameDatePart.extractDatePart(date, datePart), IsSameDatePart.format(date, format), datePart, datePartLabel, format);
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        int actualDatePart = IsSameDatePart.extractDatePart(actual, this.datePart);
        if (this.expected != actualDatePart) {
            mismatchDesc.appendText(this.datePartLabel).appendText(" is ").appendValue((Object)IsSameDatePart.format(actual, this.dateFormat));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a ").appendText(this.datePartLabel).appendText(" of ").appendValue((Object)this.expectedValueDescription);
    }

    private static int extractDatePart(Date date, int part) {
        return IsSameDatePart.convertDateToCalendar(date).get(part);
    }

    private static Calendar convertDateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }
}

