/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import uk.co.it.modular.hamcrest.date.DateFormatter;
import uk.co.it.modular.hamcrest.date.Months;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsSameInstant
extends TypeSafeDiagnosingMatcher<Date> {
    private final Date expected;

    public IsSameInstant(Date expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        if (this.expected.getTime() != actual.getTime()) {
            mismatchDesc.appendText("date is ").appendValue((Object)DateFormatter.formatDateWithMillis(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the same date as ").appendValue((Object)DateFormatter.formatDateWithMillis(this.expected));
    }

    @Factory
    public static Matcher<Date> sameInstant(Date date) {
        return new IsSameInstant(date);
    }

    @Factory
    public static Matcher<Date> sameInstant(long timestamp) {
        return new IsSameInstant(new Date(timestamp));
    }

    @Deprecated
    public static Matcher<Date> sameIntstance(int year, Months month, int date, int hour, int minute, int second, int milliseconds) {
        return IsSameInstant.sameInstant(year, month, date, hour, minute, second, milliseconds);
    }

    @Factory
    public static Matcher<Date> sameInstant(int year, Months month, int date, int hour, int minute, int second, int milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month.calendarConstant(), date, hour, minute, second);
        calendar.set(14, milliseconds);
        return new IsSameInstant(calendar.getTime());
    }
}

