/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import uk.co.it.modular.hamcrest.date.DateFormatter;
import uk.co.it.modular.hamcrest.date.DayMonthYear;
import uk.co.it.modular.hamcrest.date.Months;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsWithin
extends TypeSafeDiagnosingMatcher<Date> {
    private final long period;
    private final TimeUnit unit;
    private final Date expected;
    private final long expectedDifferenceInMillis;

    public IsWithin(long period, TimeUnit unit, Date expected) {
        this.period = period;
        this.unit = unit;
        this.expected = expected;
        this.expectedDifferenceInMillis = unit.toMillis(period);
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        long differenceInMillis = Math.abs(this.expected.getTime() - actual.getTime());
        if (differenceInMillis > this.expectedDifferenceInMillis) {
            mismatchDesc.appendText("date is ").appendValue((Object)DateFormatter.formatDateWithMillis(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is within " + this.period + " " + this.abbreviatedUnit(this.unit) + " of ").appendValue((Object)DateFormatter.formatDateWithMillis(this.expected));
    }

    private String abbreviatedUnit(TimeUnit unit) {
        switch (unit) {
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MINUTES: {
                return "mins";
            }
            case NANOSECONDS: {
                return "ns";
            }
            case SECONDS: {
                return "secs";
            }
        }
        return unit.name().toLowerCase();
    }

    @Factory
    public static Matcher<Date> within(long period, TimeUnit unit, Date date) {
        return new IsWithin(period, unit, date);
    }

    @Factory
    public static Matcher<Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return IsWithin.within(period, unit, date.getYear(), date.getMonth(), date.getDay());
    }

    @Factory
    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int day) {
        return IsWithin.within(period, unit, year, month, day, 0, 0, 0, 0);
    }

    @Factory
    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int date, int hour, int minute, int second, int milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month.calendarConstant(), date, hour, minute, second);
        calendar.set(14, milliseconds);
        return new IsWithin(period, unit, calendar.getTime());
    }
}

