/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import org.agrona.AbstractMutableDirectBuffer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;

public class ExpandableDirectByteBuffer
extends AbstractMutableDirectBuffer {
    static final int ALIGNMENT = 32;
    public static final int MAX_BUFFER_LENGTH = 2147483584;
    public static final int INITIAL_CAPACITY = 128;
    private ByteBuffer byteBuffer;
    private int alignmentOffset;

    public ExpandableDirectByteBuffer() {
        this(128);
    }

    public ExpandableDirectByteBuffer(int initialCapacity) {
        this.byteBuffer = ByteBuffer.allocateDirect(initialCapacity + 32);
        long address = BufferUtil.address(this.byteBuffer);
        this.alignmentOffset = ExpandableDirectByteBuffer.calculateAlignmentOffset(address);
        this.addressOffset = address + (long)this.alignmentOffset;
        this.capacity = initialCapacity;
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] byteArray() {
        return null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public int wrapAdjustment() {
        return this.alignmentOffset;
    }

    @Override
    public void checkLimit(int limit) {
        this.ensureCapacity(limit, 0);
    }

    public String toString() {
        return "ExpandableDirectByteBuffer{address=" + this.addressOffset + ", capacity=" + this.capacity + ", byteBuffer=" + this.byteBuffer + '}';
    }

    @Override
    protected final void ensureCapacity(int index, int length) {
        if (index < 0 || length < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        long resultingPosition = (long)index + (long)length;
        int currentCapacity = this.capacity;
        if (resultingPosition > (long)currentCapacity) {
            if (resultingPosition > 2147483584L) {
                throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " maxCapacity=" + 2147483584);
            }
            int newCapacity = ExpandableDirectByteBuffer.calculateExpansion(currentCapacity, resultingPosition);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity + 32);
            long newAddress = BufferUtil.address(newBuffer);
            int newOffset = ExpandableDirectByteBuffer.calculateAlignmentOffset(newAddress);
            this.getBytes(0, newBuffer, newOffset, currentCapacity);
            this.byteBuffer = newBuffer;
            this.addressOffset = newAddress + (long)newOffset;
            this.alignmentOffset = newOffset;
            this.capacity = newCapacity;
        }
    }

    private static int calculateExpansion(int currentLength, long requiredLength) {
        long value = Math.max(currentLength, 2);
        while (value < requiredLength) {
            if ((value += value >> 1) <= 2147483584L) continue;
            value = 2147483584L;
        }
        return (int)value;
    }

    private static int calculateAlignmentOffset(long address) {
        int remainder = (int)(address & 0x1FL);
        return 32 - remainder;
    }
}

