/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.play.audit.http;

import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;
import uk.gov.hmrc.play.audit.EventKeys$;
import uk.gov.hmrc.play.audit.EventTypes$;
import uk.gov.hmrc.play.audit.http.HeaderCarrier;
import uk.gov.hmrc.play.audit.http.HeaderFieldsExtractor$;
import uk.gov.hmrc.play.audit.http.HttpAuditing;
import uk.gov.hmrc.play.audit.model.DataCall;
import uk.gov.hmrc.play.audit.model.MergedDataEvent;
import uk.gov.hmrc.play.audit.model.MergedDataEvent$;
import uk.gov.hmrc.play.http.HttpResponse;

public abstract class HttpAuditing$class {
    public static Regex auditDisabledForPattern(HttpAuditing $this) {
        return new StringOps(Predef$.MODULE$.augmentString("http://.*\\.service")).r();
    }

    public static void auditRequestWithResponseF(HttpAuditing $this, String url, String verb, Option body, Future responseToAuditF, HeaderCarrier hc) {
        HttpAuditing.HttpRequest request = new HttpAuditing.HttpRequest($this, url, verb, body, $this.now());
        responseToAuditF.map((Function1)new Serializable($this, request, hc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpAuditing $outer;
            private final HttpAuditing.HttpRequest request$1;
            private final HeaderCarrier hc$1;

            public final void apply(HttpResponse response) {
                this.$outer.audit(this.request$1, response, this.hc$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.hc$1 = hc$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()).recover((PartialFunction)new Serializable($this, request, hc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpAuditing $outer;
            private final HttpAuditing.HttpRequest request$1;
            private final HeaderCarrier hc$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.auditRequestWithException(this.request$1, A12.getMessage(), this.hc$1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.hc$1 = hc$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public static void auditFromPlayFrontend(HttpAuditing $this, String url, HttpResponse response, HeaderCarrier hc) {
        $this.audit(new HttpAuditing.HttpRequest($this, url, "", (Option<?>)None$.MODULE$, $this.now()), response, hc);
    }

    public static void audit(HttpAuditing $this, HttpAuditing.HttpRequest request, HttpResponse responseToAudit, HeaderCarrier hc) {
        if (HttpAuditing$class.isAuditable($this, request.url())) {
            $this.auditConnector().sendMergedEvent(HttpAuditing$class.dataEventFor($this, request, responseToAudit, hc), hc, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        }
    }

    public static void auditRequestWithException(HttpAuditing $this, HttpAuditing.HttpRequest request, String errorMessage, HeaderCarrier hc) {
        if (HttpAuditing$class.isAuditable($this, request.url())) {
            $this.auditConnector().sendMergedEvent(HttpAuditing$class.dataEventFor($this, request, errorMessage, hc), hc, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        }
    }

    private static MergedDataEvent dataEventFor(HttpAuditing $this, HttpAuditing.HttpRequest request, String errorMesssage, HeaderCarrier hc) {
        Map responseDetails = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.FailedRequestMessage()), (Object)errorMesssage)}));
        return HttpAuditing$class.buildDataEvent($this, request, responseDetails, hc);
    }

    private static MergedDataEvent dataEventFor(HttpAuditing $this, HttpAuditing.HttpRequest request, HttpResponse response, HeaderCarrier hc) {
        Map responseDetails = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.ResponseMessage()), (Object)response.body()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.StatusCode()), (Object)((Object)BoxesRunTime.boxToInteger((int)response.status())).toString())}));
        return HttpAuditing$class.buildDataEvent($this, request, responseDetails, hc);
    }

    private static MergedDataEvent buildDataEvent(HttpAuditing $this, HttpAuditing.HttpRequest request, Map responseDetails, HeaderCarrier hc) {
        String x$1 = $this.appName();
        String x$2 = EventTypes$.MODULE$.OutboundCall();
        DataCall x$3 = new DataCall(hc.toAuditTags(request.url(), request.url()), hc.toAuditDetails((Seq<Tuple2<String, String>>)HttpAuditing$class.requestDetails($this, request, hc)), request.generatedAt());
        DataCall x$4 = new DataCall((Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)responseDetails, $this.now());
        String x$5 = MergedDataEvent$.MODULE$.apply$default$3();
        return new MergedDataEvent(x$1, x$2, x$5, x$3, x$4);
    }

    private static Seq requestDetails(HttpAuditing $this, HttpAuditing.HttpRequest request, HeaderCarrier hc) {
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.Path()), (Object)request.url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.Method()), (Object)request.verb())}))).$plus$plus((GenTraversableOnce)request.body().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, String>> apply(Object b) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EventKeys$.MODULE$.RequestBody()), (Object)b.toString())}));
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }), Seq$.MODULE$.canBuildFrom())).$plus$plus(HeaderFieldsExtractor$.MODULE$.optionalAuditFields((Map<String, String>)hc.extraHeaders().toMap(Predef$.MODULE$.$conforms())), Seq$.MODULE$.canBuildFrom());
    }

    private static boolean isAuditable(HttpAuditing $this, String url) {
        return !url.contains("/write/audit") && !$this.auditDisabledForPattern().findFirstIn((CharSequence)url).isDefined();
    }

    public static void $init$(HttpAuditing $this) {
    }
}

