/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.play.http;

import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import uk.gov.hmrc.play.http.BadRequestException;
import uk.gov.hmrc.play.http.HttpErrorFunctions;
import uk.gov.hmrc.play.http.HttpResponse;
import uk.gov.hmrc.play.http.NotFoundException;
import uk.gov.hmrc.play.http.Upstream4xxResponse;
import uk.gov.hmrc.play.http.Upstream5xxResponse;

public abstract class HttpErrorFunctions$class {
    public static String notFoundMessage(HttpErrorFunctions $this, String verbName, String url, String responseBody) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' returned 404 (Not Found). Response body: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, responseBody}));
    }

    public static String preconditionFailedMessage(HttpErrorFunctions $this, String verbName, String url, String responseBody) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' returned 412 (Precondition Failed). Response body: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, responseBody}));
    }

    public static String upstreamResponseMessage(HttpErrorFunctions $this, String verbName, String url, int status, String responseBody) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' returned ", ". Response body: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, BoxesRunTime.boxToInteger((int)status), responseBody}));
    }

    public static String badRequestMessage(HttpErrorFunctions $this, String verbName, String url, String responseBody) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' returned 400 (Bad Request). Response body '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, responseBody}));
    }

    public static String badGatewayMessage(HttpErrorFunctions $this, String verbName, String url, int status, String responseBody) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' returned status ", ". Response body: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, BoxesRunTime.boxToInteger((int)status), responseBody}));
    }

    public static String badGatewayMessage(HttpErrorFunctions $this, String verbName, String url, Exception e) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' failed. Caused by: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, e.getMessage()}));
    }

    public static String gatewayTimeoutMessage(HttpErrorFunctions $this, String verbName, String url, Exception e) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of '", "' timed out with message '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{verbName, url, e.getMessage()}));
    }

    public static boolean is2xx(HttpErrorFunctions $this, int status) {
        return status >= 200 && status < 300;
    }

    public static boolean is4xx(HttpErrorFunctions $this, int status) {
        return status >= 400 && status < 500;
    }

    public static boolean is5xx(HttpErrorFunctions $this, int status) {
        return status >= 500 && status < 600;
    }

    public static HttpResponse handleResponse(HttpErrorFunctions $this, String httpMethod, String url, HttpResponse response) {
        int n = response.status();
        if ($this.is2xx(n)) {
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        if (400 == n) {
            throw new BadRequestException($this.badRequestMessage(httpMethod, url, response.body()));
        }
        if (404 == n) {
            throw new NotFoundException($this.notFoundMessage(httpMethod, url, response.body()));
        }
        if ($this.is4xx(n)) {
            throw new Upstream4xxResponse($this.upstreamResponseMessage(httpMethod, url, n, response.body()), n, 500, response.allHeaders());
        }
        if ($this.is5xx(n)) {
            throw new Upstream5xxResponse($this.upstreamResponseMessage(httpMethod, url, response.status(), response.body()), n, 502);
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", " failed with status ", ". Response body: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{httpMethod, url, BoxesRunTime.boxToInteger((int)n), response.body()})));
    }

    public static void $init$(HttpErrorFunctions $this) {
    }
}

