/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.play.http;

import play.api.data.validation.ValidationError;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.twirl.api.Html;
import play.twirl.api.Html$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.Nothing$;
import uk.gov.hmrc.play.http.HttpErrorFunctions;
import uk.gov.hmrc.play.http.HttpErrorFunctions$class;
import uk.gov.hmrc.play.http.HttpReads;
import uk.gov.hmrc.play.http.HttpResponse;
import uk.gov.hmrc.play.http.JsValidationException;

public final class HttpReads$
implements HttpErrorFunctions {
    public static final HttpReads$ MODULE$;
    private final HttpReads<Html> readToHtml;
    private final HttpReads<HttpResponse> readRaw;

    static {
        new HttpReads$();
    }

    @Override
    public String notFoundMessage(String verbName, String url, String responseBody) {
        return HttpErrorFunctions$class.notFoundMessage(this, verbName, url, responseBody);
    }

    @Override
    public String preconditionFailedMessage(String verbName, String url, String responseBody) {
        return HttpErrorFunctions$class.preconditionFailedMessage(this, verbName, url, responseBody);
    }

    @Override
    public String upstreamResponseMessage(String verbName, String url, int status, String responseBody) {
        return HttpErrorFunctions$class.upstreamResponseMessage(this, verbName, url, status, responseBody);
    }

    @Override
    public String badRequestMessage(String verbName, String url, String responseBody) {
        return HttpErrorFunctions$class.badRequestMessage(this, verbName, url, responseBody);
    }

    @Override
    public String badGatewayMessage(String verbName, String url, int status, String responseBody) {
        return HttpErrorFunctions$class.badGatewayMessage(this, verbName, url, status, responseBody);
    }

    @Override
    public String badGatewayMessage(String verbName, String url, Exception e) {
        return HttpErrorFunctions$class.badGatewayMessage(this, verbName, url, e);
    }

    @Override
    public String gatewayTimeoutMessage(String verbName, String url, Exception e) {
        return HttpErrorFunctions$class.gatewayTimeoutMessage(this, verbName, url, e);
    }

    @Override
    public boolean is2xx(int status) {
        return HttpErrorFunctions$class.is2xx(this, status);
    }

    @Override
    public boolean is4xx(int status) {
        return HttpErrorFunctions$class.is4xx(this, status);
    }

    @Override
    public boolean is5xx(int status) {
        return HttpErrorFunctions$class.is5xx(this, status);
    }

    @Override
    public HttpResponse handleResponse(String httpMethod, String url, HttpResponse response) {
        return HttpErrorFunctions$class.handleResponse(this, httpMethod, url, response);
    }

    public <P> HttpReads<Option<P>> readOptionOf(HttpReads<P> rds) {
        return new HttpReads<Option<P>>(rds){
            private final HttpReads rds$1;

            public Option<P> read(String method, String url, HttpResponse response) {
                None$ none$;
                int n = response.status();
                switch (n) {
                    default: {
                        none$ = new Some(this.rds$1.read(method, url, response));
                        break;
                    }
                    case 204: 
                    case 404: {
                        none$ = None$.MODULE$;
                    }
                }
                return none$;
            }
            {
                this.rds$1 = rds$1;
            }
        };
    }

    public HttpReads<Html> readToHtml() {
        return this.readToHtml;
    }

    public <O> HttpReads<O> readFromJson(Reads<O> rds, Manifest<O> mf) {
        return new HttpReads<O>(rds, mf){
            private final Reads rds$2;
            private final Manifest mf$1;

            public O read(String method, String url, HttpResponse response) {
                return (O)HttpReads$.MODULE$.readJson(method, url, HttpReads$.MODULE$.handleResponse(method, url, response).json(), this.rds$2, this.mf$1);
            }
            {
                this.rds$2 = rds$2;
                this.mf$1 = mf$1;
            }
        };
    }

    public HttpReads<HttpResponse> readRaw() {
        return this.readRaw;
    }

    public <O> Object readSeqFromJsonProperty(String name, Reads<O> rds, Manifest<O> mf) {
        return new HttpReads<Seq<O>>(name, rds, mf){
            private final String name$1;
            private final Reads rds$3;
            private final Manifest mf$3;

            public Seq<O> read(String method, String url, HttpResponse response) {
                Seq seq;
                int n = response.status();
                switch (n) {
                    default: {
                        seq = (Seq)HttpReads$.MODULE$.readJson(method, url, HttpReads$.MODULE$.handleResponse(method, url, response).json().$bslash(this.name$1), Reads$.MODULE$.traversableReads(Seq$.MODULE$.canBuildFrom(), this.rds$3), ManifestFactory$.MODULE$.classType(Seq.class, this.mf$3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                        break;
                    }
                    case 204: 
                    case 404: {
                        seq = (Seq)Seq$.MODULE$.empty();
                    }
                }
                return seq;
            }
            {
                this.name$1 = name$1;
                this.rds$3 = rds$3;
                this.mf$3 = mf$3;
            }
        };
    }

    public <A> A readJson(String method, String url, JsValue jsValue, Reads<A> rds, Manifest<A> mf) {
        return (A)jsValue.validate(rds).fold((Function1)new Serializable(method, url, mf){
            public static final long serialVersionUID = 0L;
            private final String method$1;
            private final String url$1;
            private final Manifest mf$2;

            public final Nothing$ apply(Seq<Tuple2<JsPath, Seq<ValidationError>>> errs) {
                throw new JsValidationException(this.method$1, this.url$1, this.mf$2.runtimeClass(), errs);
            }
            {
                this.method$1 = method$1;
                this.url$1 = url$1;
                this.mf$2 = mf$2;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final A apply(A valid) {
                return valid;
            }
        });
    }

    private HttpReads$() {
        MODULE$ = this;
        HttpErrorFunctions$class.$init$(this);
        this.readToHtml = new HttpReads<Html>(){

            public Html read(String method, String url, HttpResponse response) {
                return Html$.MODULE$.apply(HttpReads$.MODULE$.handleResponse(method, url, response).body());
            }
        };
        this.readRaw = new HttpReads<HttpResponse>(){

            public HttpResponse read(String method, String url, HttpResponse response) {
                return HttpReads$.MODULE$.handleResponse(method, url, response);
            }
        };
    }
}

