/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.play.audit.http.connector;

import play.api.Logger$;
import play.api.http.ContentTypeOf$;
import play.api.http.Writeable$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.ws.WSResponse;
import play.api.mvc.Codec$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import uk.gov.hmrc.play.audit.http.HeaderCarrier;
import uk.gov.hmrc.play.audit.http.HeaderCarrier$;
import uk.gov.hmrc.play.audit.http.connector.AuditConnector;
import uk.gov.hmrc.play.audit.http.connector.AuditResult;
import uk.gov.hmrc.play.audit.http.connector.AuditResult$Disabled$;
import uk.gov.hmrc.play.audit.http.connector.AuditResult$Failure$;
import uk.gov.hmrc.play.audit.http.connector.AuditResult$Success$;
import uk.gov.hmrc.play.audit.model.AuditEvent;
import uk.gov.hmrc.play.audit.model.AuditEvent$;
import uk.gov.hmrc.play.audit.model.MergedDataEvent;
import uk.gov.hmrc.play.audit.model.MergedDataEvent$;
import uk.gov.hmrc.play.http.HttpResponse;
import uk.gov.hmrc.play.http.logging.LoggingDetails;
import uk.gov.hmrc.play.http.logging.MdcLoggingExecutionContext$;
import uk.gov.hmrc.play.http.ws.WSHttpResponse;

public abstract class AuditConnector$class {
    public static Future callAuditConsumer(AuditConnector $this, String url, JsValue body, HeaderCarrier hc, ExecutionContext ec) {
        return $this.withTracing("Post", url, new Serializable($this, url, body, hc, ec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AuditConnector $outer;
            private final String url$1;
            private final JsValue body$1;
            private final HeaderCarrier hc$2;
            private final ExecutionContext ec$1;

            public final Future<WSHttpResponse> apply() {
                return this.$outer.buildRequest(this.url$1, this.hc$2).post((Object)this.body$1, Writeable$.MODULE$.writeableOf_JsValue(Codec$.MODULE$.utf_8()), ContentTypeOf$.MODULE$.contentTypeOf_JsValue(Codec$.MODULE$.utf_8())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WSHttpResponse apply(WSResponse x$1) {
                        return new WSHttpResponse(x$1);
                    }
                }, this.ec$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.url$1 = url$1;
                this.body$1 = body$1;
                this.hc$2 = hc$2;
                this.ec$1 = ec$1;
            }
        }, hc);
    }

    public static void logError(AuditConnector $this, String s) {
        Logger$.MODULE$.warn((Function0)new Serializable($this, s){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final String apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public static void logError(AuditConnector $this, String s, Throwable t) {
        Logger$.MODULE$.warn((Function0)new Serializable($this, s){
            public static final long serialVersionUID = 0L;
            private final String s$2;

            public final String apply() {
                return this.s$2;
            }
            {
                this.s$2 = s$2;
            }
        }, (Function0)new Serializable($this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public static Future sendEvent(AuditConnector $this, AuditEvent event, HeaderCarrier hc, ExecutionContext ec) {
        return AuditConnector$class.sendEvent($this, $this.auditingConfig().consumer().singleEventUrl(), Json$.MODULE$.toJson((Object)event, AuditEvent$.MODULE$.auditEventFormat()), hc);
    }

    public static Future sendMergedEvent(AuditConnector $this, MergedDataEvent event, HeaderCarrier hc, ExecutionContext ec) {
        return AuditConnector$class.sendEvent($this, $this.auditingConfig().consumer().mergedEventUrl(), Json$.MODULE$.toJson((Object)event, MergedDataEvent$.MODULE$.eventFormats()), hc);
    }

    public static HeaderCarrier sendMergedEvent$default$2(AuditConnector $this, MergedDataEvent event) {
        return new HeaderCarrier(HeaderCarrier$.MODULE$.apply$default$1(), HeaderCarrier$.MODULE$.apply$default$2(), HeaderCarrier$.MODULE$.apply$default$3(), HeaderCarrier$.MODULE$.apply$default$4(), HeaderCarrier$.MODULE$.apply$default$5(), HeaderCarrier$.MODULE$.apply$default$6(), HeaderCarrier$.MODULE$.apply$default$7(), HeaderCarrier$.MODULE$.apply$default$8(), HeaderCarrier$.MODULE$.apply$default$9());
    }

    public static Future sendLargeMergedEvent(AuditConnector $this, MergedDataEvent event, HeaderCarrier hc) {
        return AuditConnector$class.sendEvent($this, $this.auditingConfig().consumer().largeMergedEventUrl(), Json$.MODULE$.toJson((Object)event, MergedDataEvent$.MODULE$.eventFormats()), hc);
    }

    public static HeaderCarrier sendLargeMergedEvent$default$2(AuditConnector $this, MergedDataEvent event) {
        return new HeaderCarrier(HeaderCarrier$.MODULE$.apply$default$1(), HeaderCarrier$.MODULE$.apply$default$2(), HeaderCarrier$.MODULE$.apply$default$3(), HeaderCarrier$.MODULE$.apply$default$4(), HeaderCarrier$.MODULE$.apply$default$5(), HeaderCarrier$.MODULE$.apply$default$6(), HeaderCarrier$.MODULE$.apply$default$7(), HeaderCarrier$.MODULE$.apply$default$8(), HeaderCarrier$.MODULE$.apply$default$9());
    }

    private static Future sendEvent(AuditConnector $this, String url, JsValue body, HeaderCarrier hc) {
        Future future;
        if ($this.auditingConfig().enabled()) {
            future = $this.handleResult($this.callAuditConsumer(url, body, hc, MdcLoggingExecutionContext$.MODULE$.fromLoggingDetails(hc)), body, hc).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final AuditResult$Success$ apply(HttpResponse x$2) {
                    return AuditResult$Success$.MODULE$;
                }
            }, MdcLoggingExecutionContext$.MODULE$.fromLoggingDetails(hc));
        } else {
            Logger$.MODULE$.info((Function0)new Serializable($this, hc){
                public static final long serialVersionUID = 0L;
                private final HeaderCarrier hc$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auditing disabled for request-id ", ", session-id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hc$1.requestId(), this.hc$1.sessionId()}));
                }
                {
                    this.hc$1 = hc$1;
                }
            });
            future = Future$.MODULE$.successful((Object)AuditResult$Disabled$.MODULE$);
        }
        return future;
    }

    public static HeaderCarrier sendEvent$default$2(AuditConnector $this, AuditEvent event) {
        return new HeaderCarrier(HeaderCarrier$.MODULE$.apply$default$1(), HeaderCarrier$.MODULE$.apply$default$2(), HeaderCarrier$.MODULE$.apply$default$3(), HeaderCarrier$.MODULE$.apply$default$4(), HeaderCarrier$.MODULE$.apply$default$5(), HeaderCarrier$.MODULE$.apply$default$6(), HeaderCarrier$.MODULE$.apply$default$7(), HeaderCarrier$.MODULE$.apply$default$8(), HeaderCarrier$.MODULE$.apply$default$9());
    }

    public static Future handleResult(AuditConnector $this, Future resultF, JsValue body, LoggingDetails ld) {
        return resultF.recoverWith((PartialFunction)new Serializable($this, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AuditConnector $outer;
            private final JsValue body$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String message = this.$outer.makeFailureMessage(this.body$2);
                this.$outer.logError(message, A1);
                Future future = Future$.MODULE$.failed((Throwable)new AuditResult.Failure(message, (Option<Throwable>)new Some(A1)));
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.body$2 = body$2;
            }
        }, MdcLoggingExecutionContext$.MODULE$.fromLoggingDetails(ld)).map((Function1)new Serializable($this, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AuditConnector $outer;
            private final JsValue body$2;

            public final HttpResponse apply(HttpResponse response) {
                Option<String> option = this.$outer.checkResponse(this.body$2, response);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String error = (String)some.x();
                    this.$outer.logError(error);
                    throw new AuditResult.Failure(error, AuditResult$Failure$.MODULE$.apply$default$2());
                }
                if (None$.MODULE$.equals(option)) {
                    HttpResponse httpResponse = response;
                    return httpResponse;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.body$2 = body$2;
            }
        }, MdcLoggingExecutionContext$.MODULE$.fromLoggingDetails(ld));
    }

    public static String makeFailureMessage(AuditConnector $this, JsValue body) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : audit item : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.LoggingAuditRequestFailureKey(), body}));
    }

    public static Option checkResponse(AuditConnector $this, JsValue body, HttpResponse response) {
        return response.status() >= 300 ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : status code : ", " : audit item : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.LoggingAuditFailureResponseKey(), BoxesRunTime.boxToInteger((int)response.status()), body}))) : None$.MODULE$;
    }

    public static void $init$(AuditConnector $this) {
    }
}

