/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.oracle;

import java.sql.Connection;
import java.util.Map;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import sf.util.DatabaseUtility;

public class OracleExecutable
extends BaseExecutable {
    protected OracleExecutable(String command) {
        super(command);
    }

    public void execute(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws Exception {
        this.executeOracleScripts(connection);
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        executable.setAdditionalConfiguration(this.additionalConfiguration);
        executable.setOutputOptions(this.outputOptions);
        executable.execute(connection, databaseSpecificOverrideOptions);
    }

    private void executeOracleScripts(Connection connection) throws SchemaCrawlerException {
        DatabaseUtility.executeScriptFromResource((Connection)connection, (String)"/schemacrawler-oracle.before.sql");
        SchemaTextOptions schemaTextOptions = (SchemaTextOptions)new SchemaTextOptionsBuilder().fromConfig((Map)this.additionalConfiguration).toOptions();
        if (schemaTextOptions.isShowUnqualifiedNames()) {
            DatabaseUtility.executeScriptFromResource((Connection)connection, (String)"/schemacrawler-oracle.show_unqualified_names.sql");
        }
    }
}

