SELECT /*+ PARALLEL(AUTO) */
  NULL AS CONSTRAINT_CATALOG,
  TABLE_CONTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  TABLE_CONTRAINTS.CONSTRAINT_NAME,
  NULL AS TABLE_CATALOG,
  TABLE_CONTRAINTS.OWNER AS TABLE_SCHEMA,
  TABLE_CONTRAINTS.TABLE_NAME,
  COLUMNS.COLUMN_NAME,
  COLUMNS.POSITION AS ORDINAL_POSITION
FROM
  ALL_CONSTRAINTS TABLE_CONTRAINTS
  INNER JOIN ALL_CONS_COLUMNS COLUMNS
    ON TABLE_CONTRAINTS.OWNER = COLUMNS.OWNER 
      AND TABLE_CONTRAINTS.TABLE_NAME = COLUMNS.TABLE_NAME 
      AND TABLE_CONTRAINTS.CONSTRAINT_NAME = COLUMNS.CONSTRAINT_NAME
  INNER JOIN ALL_USERS USERS
    ON TABLE_CONTRAINTS.OWNER = USERS.USERNAME  
WHERE
  USERS.USERNAME NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'HR', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL')  
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5,6}$')
  AND TABLE_CONTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND TABLE_CONTRAINTS.CONSTRAINT_TYPE IN ('C', 'U', 'P', 'R')
