SELECT /*+ PARALLEL(AUTO) */
  NULL AS CONSTRAINT_CATALOG,
  CONSTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONSTRAINT_NAME,
  DBMS_METADATA.GET_DDL('CONSTRAINT', CONSTRAINTS.CONSTRAINT_NAME, CONSTRAINTS.OWNER) 
    AS CHECK_CLAUSE
FROM
  ALL_CONSTRAINTS CONSTRAINTS
  INNER JOIN ALL_USERS USERS
    ON CONSTRAINTS.OWNER = USERS.USERNAME
WHERE
  USERS.USERNAME NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'HR', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL')  
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5,6}$')
  AND CONSTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND CONSTRAINT_TYPE IN ('C', 'U', 'P')
UNION ALL
SELECT
  NULL AS CONSTRAINT_CATALOG,
  CONSTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONSTRAINT_NAME,
  DBMS_METADATA.GET_DDL('REF_CONSTRAINT', CONSTRAINTS.CONSTRAINT_NAME, CONSTRAINTS.OWNER) 
    AS CHECK_CLAUSE
FROM
  ALL_CONSTRAINTS CONSTRAINTS
  INNER JOIN ALL_USERS USERS
    ON CONSTRAINTS.OWNER = USERS.USERNAME
WHERE
  USERS.USERNAME NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'HR', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL')  
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5,6}$')
  AND CONSTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND CONSTRAINT_TYPE = 'R'
