/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import ws.wamp.jawampa.ApplicationError;
import ws.wamp.jawampa.WampRouter;
import ws.wamp.jawampa.WampSerialization;
import ws.wamp.jawampa.transport.netty.WampServerWebsocketHandler;

public class SimpleWampWebsocketListener {
    State state = State.Intialized;
    final EventLoopGroup bossGroup;
    final EventLoopGroup clientGroup;
    final WampRouter router;
    final URI uri;
    SslContext sslCtx;
    List<WampSerialization> serializations;
    Channel channel;
    boolean started = false;

    public SimpleWampWebsocketListener(WampRouter router, URI uri, SslContext sslContext) throws ApplicationError {
        this(router, uri, sslContext, WampSerialization.defaultSerializations());
    }

    public SimpleWampWebsocketListener(WampRouter router, URI uri, SslContext sslContext, List<WampSerialization> serializations) throws ApplicationError {
        this.router = router;
        this.uri = uri;
        this.serializations = serializations;
        if (serializations == null || serializations.size() == 0 || serializations.contains(WampSerialization.Invalid)) {
            throw new ApplicationError("jawampa.error.invalid_serializations");
        }
        this.bossGroup = new NioEventLoopGroup(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "WampRouterBossLoop");
            }
        });
        this.clientGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            private AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "WampRouterClientLoop-" + this.counter.incrementAndGet());
            }
        });
        if (uri.getScheme().equalsIgnoreCase("wss")) {
            this.sslCtx = sslContext;
        }
    }

    public void start() {
        if (this.state != State.Intialized) {
            return;
        }
        try {
            if (this.uri.getScheme().equalsIgnoreCase("wss") && this.sslCtx == null) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                this.sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            }
            int port = this.uri.getPort() == -1 ? (this.sslCtx != null ? 443 : 80) : this.uri.getPort();
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.clientGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitializer(this.uri, this.sslCtx));
            this.channel = b.bind(this.uri.getHost(), port).sync().channel();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.state == State.Closed) {
            return;
        }
        if (this.channel != null) {
            try {
                this.channel.close().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.channel = null;
        }
        this.bossGroup.shutdownGracefully();
        this.clientGroup.shutdownGracefully();
        this.state = State.Closed;
    }

    public static class WebSocketServerHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private final URI uri;

        WebSocketServerHandler(URI uri) {
            this.uri = uri;
        }

        public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
            this.handleHttpRequest(ctx, msg);
        }

        private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
            if (!req.decoderResult().isSuccess()) {
                WebSocketServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
                return;
            }
            if (req.method() != HttpMethod.GET) {
                WebSocketServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                return;
            }
            if ("/".equals(req.uri())) {
                ByteBuf content = Unpooled.copiedBuffer((CharSequence)("<html><head><title>Wamp Router</title></head><body><h1>This server provides a wamp router on path " + this.uri.getPath() + "</h1>" + "</body></html>"), (Charset)CharsetUtil.UTF_8);
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
                HttpUtil.setContentLength((HttpMessage)res, (long)content.readableBytes());
                WebSocketServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
                return;
            }
            if ("/favicon.ico".equals(req.uri())) {
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                WebSocketServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
                return;
            }
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            WebSocketServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        }

        private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
            if (res.status().code() != 200) {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
                res.content().writeBytes(buf);
                buf.release();
                HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
            }
            ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
            if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            ctx.close();
        }
    }

    private class WebSocketServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final URI uri;
        private final SslContext sslCtx;

        public WebSocketServerInitializer(URI uri, SslContext sslCtx) {
            this.uri = uri;
            this.sslCtx = sslCtx;
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.sslCtx != null) {
                pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
            pipeline.addLast(new ChannelHandler[]{new WampServerWebsocketHandler(this.uri.getPath().length() == 0 ? "/" : this.uri.getPath(), SimpleWampWebsocketListener.this.router, SimpleWampWebsocketListener.this.serializations)});
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.uri)});
        }
    }

    static enum State {
        Intialized,
        Started,
        Closed;

    }
}

