/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.util.List;
import ws.wamp.jawampa.WampMessages;
import ws.wamp.jawampa.WampSerialization;

public class WampDeserializationHandler
extends MessageToMessageDecoder<WebSocketFrame> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WampDeserializationHandler.class);
    ReadState readState = ReadState.Closed;
    final WampSerialization serialization;

    public WampSerialization serialization() {
        return this.serialization;
    }

    public WampDeserializationHandler(WampSerialization serialization) {
        this.serialization = serialization;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.readState = ReadState.Reading;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.readState = ReadState.Reading;
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.readState = ReadState.Closed;
        ctx.fireChannelInactive();
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (this.readState != ReadState.Reading) {
            return;
        }
        ObjectMapper objectMapper = this.serialization.getObjectMapper();
        if (frame instanceof TextWebSocketFrame) {
            if (!this.serialization.isText()) {
                throw new IllegalStateException("Received unexpected TextFrame");
            }
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            ArrayNode arr = (ArrayNode)objectMapper.readValue((InputStream)new ByteBufInputStream(textFrame.content()), ArrayNode.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Deserialized Wamp Message: {}", (Object)arr.toString());
            }
            WampMessages.WampMessage recvdMessage = WampMessages.WampMessage.fromObjectArray((ArrayNode)arr);
            out.add(recvdMessage);
        } else if (frame instanceof BinaryWebSocketFrame) {
            if (this.serialization.isText()) {
                throw new IllegalStateException("Received unexpected BinaryFrame");
            }
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            ArrayNode arr = (ArrayNode)objectMapper.readValue((InputStream)new ByteBufInputStream(binaryFrame.content()), ArrayNode.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Deserialized Wamp Message: {}", (Object)arr.toString());
            }
            WampMessages.WampMessage recvdMessage = WampMessages.WampMessage.fromObjectArray((ArrayNode)arr);
            out.add(recvdMessage);
        } else if (!(frame instanceof PongWebSocketFrame) && frame instanceof CloseWebSocketFrame) {
            this.readState = ReadState.Closed;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.readState = ReadState.Error;
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    static enum ReadState {
        Closed,
        Reading,
        Error;

    }
}

