/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.OutputStream;
import java.util.List;
import ws.wamp.jawampa.WampMessages;
import ws.wamp.jawampa.WampSerialization;

public class WampSerializationHandler
extends MessageToMessageEncoder<WampMessages.WampMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WampSerializationHandler.class);
    final WampSerialization serialization;

    public WampSerialization serialization() {
        return this.serialization;
    }

    public WampSerializationHandler(WampSerialization serialization) {
        this.serialization = serialization;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    protected void encode(ChannelHandlerContext ctx, WampMessages.WampMessage msg, List<Object> out) throws Exception {
        TextWebSocketFrame frame;
        ByteBuf msgBuffer = Unpooled.buffer();
        ByteBufOutputStream outStream = new ByteBufOutputStream(msgBuffer);
        ObjectMapper objectMapper = this.serialization.getObjectMapper();
        try {
            JsonNode node = msg.toObjectArray(objectMapper);
            objectMapper.writeValue((OutputStream)outStream, (Object)node);
            if (logger.isDebugEnabled()) {
                logger.debug("Serialized Wamp Message: {}", (Object)node.toString());
            }
        }
        catch (Exception e) {
            msgBuffer.release();
            return;
        }
        if (this.serialization.isText()) {
            frame = new TextWebSocketFrame(msgBuffer);
            out.add(frame);
        } else {
            frame = new BinaryWebSocketFrame(msgBuffer);
            out.add(frame);
        }
    }
}

