/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import ws.wamp.jawampa.WampMessages;
import ws.wamp.jawampa.WampRouter;
import ws.wamp.jawampa.WampSerialization;
import ws.wamp.jawampa.connection.IWampConnection;
import ws.wamp.jawampa.connection.IWampConnectionAcceptor;
import ws.wamp.jawampa.connection.IWampConnectionListener;
import ws.wamp.jawampa.connection.IWampConnectionPromise;
import ws.wamp.jawampa.transport.netty.WampDeserializationHandler;
import ws.wamp.jawampa.transport.netty.WampSerializationHandler;

public class WampServerWebsocketHandler
extends ChannelInboundHandlerAdapter {
    final String websocketPath;
    final WampRouter router;
    final IWampConnectionAcceptor connectionAcceptor;
    final List<WampSerialization> supportedSerializations;
    WampSerialization serialization = WampSerialization.Invalid;
    boolean handshakeInProgress = false;

    public WampServerWebsocketHandler(String websocketPath, WampRouter router) {
        this(websocketPath, router, WampSerialization.defaultSerializations());
    }

    public WampServerWebsocketHandler(String websocketPath, WampRouter router, List<WampSerialization> supportedSerializations) {
        this.websocketPath = websocketPath;
        this.router = router;
        this.connectionAcceptor = router.connectionAcceptor();
        this.supportedSerializations = supportedSerializations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request;
        FullHttpRequest fullHttpRequest = request = msg instanceof FullHttpRequest ? (FullHttpRequest)msg : null;
        if (request != null && this.handshakeInProgress) {
            request.release();
            WampServerWebsocketHandler.sendBadRequestAndClose(ctx, null);
            return;
        }
        if (request != null && this.isUpgradeRequest(request)) {
            try {
                this.tryWebsocketHandshake(ctx, (FullHttpRequest)msg);
            }
            finally {
                request.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean isUpgradeRequest(FullHttpRequest request) {
        if (!request.decoderResult().isSuccess()) {
            return false;
        }
        String connectionHeaderValue = request.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        if (connectionHeaderValue == null) {
            return false;
        }
        AsciiString connectionHeaderString = new AsciiString((CharSequence)connectionHeaderValue);
        AsciiString[] connectionHeaderFields = connectionHeaderString.toLowerCase().split(',');
        boolean hasUpgradeField = false;
        AsciiString upgradeValue = HttpHeaderValues.UPGRADE.toLowerCase();
        for (AsciiString s : connectionHeaderFields) {
            if (!upgradeValue.equals((Object)s.trim())) continue;
            hasUpgradeField = true;
            break;
        }
        if (!hasUpgradeField) {
            return false;
        }
        if (!request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true)) {
            return false;
        }
        return request.uri().equals(this.websocketPath);
    }

    private void tryWebsocketHandshake(final ChannelHandlerContext ctx, FullHttpRequest request) {
        String subProtocols;
        String wsLocation = this.getWebSocketLocation(ctx, request);
        WebSocketServerHandshaker handshaker = new WebSocketServerHandshakerFactory(wsLocation, subProtocols = WampSerialization.makeWebsocketSubprotocolList(this.supportedSerializations), false, 0x1000000).newHandshaker((HttpRequest)request);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshakeInProgress = true;
            ChannelFuture handshakeFuture = handshaker.handshake(ctx.channel(), request);
            String actualProtocol = handshaker.selectedSubprotocol();
            this.serialization = WampSerialization.fromString((String)actualProtocol);
            if (this.serialization == WampSerialization.Invalid) {
                handshakeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ChannelHandler last = ctx.pipeline().last();
            while (last != null && last != this) {
                ctx.pipeline().removeLast();
                last = ctx.pipeline().last();
            }
            if (last == null) {
                throw new IllegalStateException("Can't find the WAMP server handler in the pipeline");
            }
            ProtocolHandler protocolHandler = new ProtocolHandler();
            ctx.pipeline().replace((ChannelHandler)this, "wamp-websocket-protocol-handler", (ChannelHandler)protocolHandler);
            ChannelHandlerContext protocolHandlerCtx = ctx.pipeline().context((ChannelHandler)protocolHandler);
            protocolHandlerCtx.pipeline().addLast(new ChannelHandler[]{new WebSocketFrameAggregator(0x1000000)});
            protocolHandlerCtx.pipeline().addLast("wamp-serializer", (ChannelHandler)new WampSerializationHandler(this.serialization));
            protocolHandlerCtx.pipeline().addLast("wamp-deserializer", (ChannelHandler)new WampDeserializationHandler(this.serialization));
            final IWampConnectionListener connectionListener = this.connectionAcceptor.createNewConnectionListener();
            final WampServerConnection connection = new WampServerConnection(this.serialization);
            SimpleChannelInboundHandler<WampMessages.WampMessage> routerHandler = new SimpleChannelInboundHandler<WampMessages.WampMessage>(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    connection.ctx = ctx;
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    WampServerWebsocketHandler.this.connectionAcceptor.acceptNewConnection((IWampConnection)connection, connectionListener);
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    connectionListener.transportClosed();
                }

                protected void channelRead0(ChannelHandlerContext ctx, WampMessages.WampMessage msg) throws Exception {
                    connectionListener.messageReceived(msg);
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    ctx.close();
                    connectionListener.transportError(cause);
                }
            };
            protocolHandlerCtx.pipeline().addLast("wamp-router", (ChannelHandler)routerHandler);
            handshakeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ctx.fireExceptionCaught(future.cause());
                    } else {
                        ctx.fireChannelActive();
                    }
                }
            });
        }
    }

    private String getWebSocketLocation(ChannelHandlerContext ctx, FullHttpRequest req) {
        String location = req.headers().get((CharSequence)HttpHeaderNames.HOST) + this.websocketPath;
        if (ctx.pipeline().get(SslHandler.class) != null) {
            return "wss://" + location;
        }
        return "ws://" + location;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketHandshakeException) {
            WampServerWebsocketHandler.sendBadRequestAndClose(ctx, cause.getMessage());
        } else {
            ctx.close();
        }
    }

    private static void sendBadRequestAndClose(ChannelHandlerContext ctx, String message) {
        DefaultFullHttpResponse response = message != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])message.getBytes())) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
        ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static class ProtocolHandler
    extends ChannelInboundHandlerAdapter {
        ReadState readState = ReadState.Reading;

        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.readState = ReadState.Closed;
            ctx.fireChannelInactive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.readState != ReadState.Reading) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (msg instanceof FullHttpRequest) {
                ((FullHttpRequest)msg).release();
                WampServerWebsocketHandler.sendBadRequestAndClose(ctx, null);
                return;
            }
            if (msg instanceof PingWebSocketFrame) {
                try {
                    ctx.writeAndFlush((Object)new PongWebSocketFrame());
                }
                finally {
                    ((PingWebSocketFrame)msg).release();
                }
            } else if (msg instanceof CloseWebSocketFrame) {
                this.readState = ReadState.Closed;
                ctx.writeAndFlush(msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.readState = ReadState.Error;
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ctx.fireExceptionCaught(cause);
        }

        static enum ReadState {
            Closed,
            Reading,
            Error;

        }
    }

    static class WampServerConnection
    implements IWampConnection {
        final WampSerialization serialization;
        ChannelHandlerContext ctx;

        public WampServerConnection(WampSerialization serialization) {
            this.serialization = serialization;
        }

        public WampSerialization serialization() {
            return this.serialization;
        }

        public boolean isSingleWriteOnly() {
            return false;
        }

        public void sendMessage(WampMessages.WampMessage message, final IWampConnectionPromise<Void> promise) {
            ChannelFuture f = this.ctx.writeAndFlush((Object)message);
            f.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess() || future.isCancelled()) {
                        promise.fulfill(null);
                    } else {
                        promise.reject(future.cause());
                    }
                }
            });
        }

        public void close(boolean sendRemaining, final IWampConnectionPromise<Void> promise) {
            this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess() || future.isCancelled()) {
                                promise.fulfill(null);
                            } else {
                                promise.reject(future.cause());
                            }
                        }
                    });
                }
            });
        }
    }
}

