/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.netty.buffer.ByteBuf;

public class LongLongInt
implements EncodableData {
    private final long value;

    private LongLongInt(long value) {
        this.value = value;
    }

    @Override
    public long getSize() {
        return 8L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeLong(this.value);
    }

    public static LongLongInt parse(long value) {
        return new LongLongInt(value);
    }

    public static LongLongInt parse(ByteBuf buf) {
        return new LongLongInt(buf.readLong());
    }

    public long getLong() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof LongLongInt && this.value == ((LongLongInt)obj).value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

