/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common;

import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.common.util.function.ThrowingConsumer;
import io.ballerina.messaging.broker.common.util.function.ThrowingFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDao.class);
    private final DataSource dataSource;

    public BaseDao(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error closing connection.", (Throwable)e);
            }
        }
    }

    protected void close(Connection connection, Statement statement) {
        this.close(statement);
        this.close(connection);
    }

    public void close(Connection connection, Statement statement, ResultSet resultSet) {
        this.close(resultSet);
        this.close(connection, statement);
    }

    protected void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error closing statement. " + statement, (Throwable)e);
            }
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error closing result set.", (Throwable)e);
            }
        }
    }

    protected String getSQLFormattedIdList(int listLength) {
        StringBuilder paramList = new StringBuilder();
        paramList.append("?");
        for (int i = 1; i < listLength; ++i) {
            paramList.append(",?");
        }
        return paramList.toString();
    }

    protected void rollback(Connection connection, String message) {
        try {
            if (Objects.nonNull(connection)) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error occurred while rolling back. Failed operation " + message, (Throwable)e);
        }
    }

    public <E extends Exception> void transaction(ThrowingConsumer<Connection, E> command) throws DaoException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            command.accept(connection);
            connection.commit();
        }
        catch (Exception e) {
            String message = "transaction operation";
            this.rollback(connection, message);
            throw new DaoException("Error occurred while " + message, e);
        }
        finally {
            this.close(connection);
        }
    }

    public <R, E extends Exception> R transaction(ThrowingFunction<Connection, R, E> command) throws DaoException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            R response = command.apply(connection);
            connection.commit();
            R r = response;
            return r;
        }
        catch (Exception e) {
            String message = "transaction operation";
            this.rollback(connection, message);
            throw new DaoException("Error occurred while " + message, e);
        }
        finally {
            this.close(connection);
        }
    }

    public <R, E extends Exception> R selectOperation(ThrowingFunction<Connection, R, E> command) throws DaoException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            R r = command.apply(connection);
            return r;
        }
        catch (Exception e) {
            String message = "select operation";
            this.rollback(connection, message);
            throw new DaoException("Error occurred while " + message, e);
        }
        finally {
            this.close(connection);
        }
    }
}

