/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FieldTable
implements EncodableData {
    public static final FieldTable EMPTY_TABLE = new FieldTable(Collections.unmodifiableMap(new HashMap()));
    private final Map<ShortString, FieldValue> properties;
    private long size = -1L;

    public FieldTable(Map<ShortString, FieldValue> properties) {
        this.properties = properties;
    }

    public FieldTable() {
        this.properties = new HashMap<ShortString, FieldValue>();
    }

    @Override
    public long getSize() {
        long tableEntrySize = 0L;
        for (Map.Entry<ShortString, FieldValue> fieldEntry : this.properties.entrySet()) {
            tableEntrySize = tableEntrySize + fieldEntry.getKey().getSize() + fieldEntry.getValue().getSize();
        }
        this.size = tableEntrySize;
        return 4L + tableEntrySize;
    }

    @Override
    public void write(ByteBuf buf) {
        if (this.size != -1L) {
            this.writeWithoutCalculatingSize(buf);
        } else {
            this.writeWithCalculatedSize(buf);
        }
    }

    private void writeWithCalculatedSize(ByteBuf buf) {
        int sizeIndex = buf.writerIndex();
        buf.writerIndex(sizeIndex + 4);
        long tableEntrySize = 0L;
        for (Map.Entry<ShortString, FieldValue> fieldEntry : this.properties.entrySet()) {
            ShortString key = fieldEntry.getKey();
            FieldValue value = fieldEntry.getValue();
            tableEntrySize = tableEntrySize + key.getSize() + value.getSize();
            key.write(buf);
            value.write(buf);
        }
        buf.setInt(sizeIndex, (int)tableEntrySize);
    }

    private void writeWithoutCalculatingSize(ByteBuf buf) {
        buf.writeInt((int)this.size);
        for (Map.Entry<ShortString, FieldValue> fieldEntry : this.properties.entrySet()) {
            fieldEntry.getKey().write(buf);
            fieldEntry.getValue().write(buf);
        }
    }

    public void add(ShortString propertyName, FieldValue value) {
        this.properties.put(propertyName, value);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof FieldTable && this.properties.equals(((FieldTable)obj).properties);
    }

    public static FieldTable parse(ByteBuf buf) throws Exception {
        long size = buf.readUnsignedInt();
        long readBytes = 0L;
        HashMap<ShortString, FieldValue> properties = new HashMap<ShortString, FieldValue>();
        while (readBytes < size) {
            ShortString key = ShortString.parse(buf);
            FieldValue value = FieldValue.parse(buf);
            properties.put(key, value);
            readBytes = readBytes + key.getSize() + value.getSize();
        }
        return new FieldTable(properties);
    }

    public FieldValue getValue(ShortString propertyName) {
        return this.properties.get(propertyName);
    }
}

