/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.netty.buffer.ByteBuf;
import java.util.Objects;

public class LongUint
implements EncodableData {
    private final long value;

    private LongUint(long value) {
        this.value = value;
    }

    @Override
    public long getSize() {
        return 4L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt((int)this.value);
    }

    public long getInt() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof LongUint && this.value == ((LongUint)obj).value;
    }

    public static LongUint parse(ByteBuf buf) {
        return new LongUint(buf.readUnsignedInt());
    }

    public static LongUint parse(long value) {
        return new LongUint(value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

