/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.netty.buffer.ByteBuf;

public class ShortUint
implements EncodableData {
    private final int value;

    private ShortUint(int value) {
        this.value = value;
    }

    @Override
    public long getSize() {
        return 2L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeShort(this.value);
    }

    public int getShort() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ShortUint && this.value == ((ShortUint)obj).value;
    }

    public static ShortUint parse(ByteBuf buf) {
        return new ShortUint(buf.readUnsignedShort());
    }

    public static ShortUint parse(int value) {
        return new ShortUint(value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

