/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.Objects;

public class Decimal
implements EncodableData {
    private final BigDecimal value;

    private Decimal(BigDecimal value) {
        this.value = value;
    }

    @Override
    public long getSize() {
        return 5L;
    }

    @Override
    public void write(ByteBuf buf) {
        byte places = (byte)this.value.scale();
        int unscaled = this.value.intValue();
        buf.writeByte((int)places);
        buf.writeInt(unscaled);
    }

    public static Decimal parse(BigDecimal value) {
        return new Decimal(value);
    }

    public static Decimal parse(ByteBuf buf) {
        byte places = buf.readByte();
        int unscaled = buf.readInt();
        BigDecimal decimal = new BigDecimal(unscaled).setScale(places);
        return new Decimal(decimal);
    }

    public BigDecimal getDecimal() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Decimal && this.value.equals(((Decimal)obj).value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

