/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.persist.ModuleUtils;
import io.ballerina.stdlib.persist.Utils;

public class QueryProcessor {
    private QueryProcessor() {
    }

    public static BStream query(Environment env, BObject client, BTypedesc recordType) {
        BString entity = Utils.getEntity(env);
        BObject persistClient = Utils.getPersistClient(client, entity);
        RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)recordType.getDescribingType());
        StreamType streamType = TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL);
        BArray[] fieldsAndIncludes = Utils.getFieldsIncludesAndTypeDescriptions((RecordType)recordType.getDescribingType());
        BArray fields = fieldsAndIncludes[0];
        BArray includes = fieldsAndIncludes[1];
        BArray typeDescriptions = fieldsAndIncludes[2];
        BFuture future = env.getRuntime().invokeMethodAsyncSequentially(persistClient, "runReadQuery", null, null, null, null, (Type)streamType, new Object[]{recordType, true, fields, true, includes, true});
        BStream sqlStream = (BStream)Utils.getFutureResult(future);
        BObject persistStream = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"PersistStream", (Object[])new Object[]{sqlStream, null, fields, includes, typeDescriptions, persistClient});
        return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)persistStream);
    }

    public static Object queryOne(Environment env, BObject client, BString key, BTypedesc recordType) {
        BString entity = Utils.getEntity(env);
        RecordType recordConstraint = (RecordType)TypeUtils.getReferredType((Type)recordType.getDescribingType());
        BArray[] fieldsAndIncludes = Utils.getFieldsIncludesAndTypeDescriptions((RecordType)recordType.getDescribingType());
        BFuture future = env.getRuntime().invokeMethodAsyncSequentially(Utils.getPersistClient(client, entity), "runReadByKeyQuery", null, null, null, null, (Type)recordConstraint, new Object[]{recordType, true, key, true, fieldsAndIncludes[0], true});
        return Utils.getFutureResult(future);
    }
}

