/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.persist.Constants;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final List<String> KNOWN_RECORD_TYPES = Arrays.asList("Civil", "Date", "TimeOfDay");

    private Utils() {
    }

    static BString getEntity(Environment env) {
        String entity = env.getFunctionName().split("\\$")[2];
        return StringUtils.fromString((String)entity);
    }

    static BObject getPersistClient(BObject client, BString entity) {
        BMap persistClients = (BMap)client.get(Constants.PERSIST_CLIENTS);
        return (BObject)persistClients.get((Object)entity);
    }

    static BArray[] getFieldsIncludesAndTypeDescriptions(RecordType recordType) {
        ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
        ArrayType typeDescriptionArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANY);
        BArray fieldsArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        BArray includeArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        BArray typeDescriptionArray = ValueCreator.createArrayValue((ArrayType)typeDescriptionArrayType);
        Map fieldsMap = recordType.getFields();
        for (Field field : fieldsMap.values()) {
            Type type = field.getFieldType();
            boolean arrayType = false;
            if (type.getTag() == 32) {
                type = ((ArrayType)type).getElementType();
                arrayType = true;
            }
            if (!(type.getTag() != 24 && type.getTag() != 53 || Utils.isKnownRecordType(type))) {
                String innerFieldName = field.getFieldName();
                includeArray.append((Object)StringUtils.fromString((String)innerFieldName));
                BArray innerFieldsArray = Utils.getInnerFieldsArray(type);
                for (int i = 0; i < innerFieldsArray.size(); ++i) {
                    if (arrayType) {
                        fieldsArray.append((Object)StringUtils.fromString((String)(innerFieldName + "[]." + innerFieldsArray.get((long)i).toString())));
                        continue;
                    }
                    fieldsArray.append((Object)StringUtils.fromString((String)(innerFieldName + "." + innerFieldsArray.get((long)i).toString())));
                }
                typeDescriptionArray.append((Object)ValueCreator.createTypedescValue((Type)type));
                continue;
            }
            fieldsArray.append((Object)StringUtils.fromString((String)field.getFieldName()));
        }
        return new BArray[]{fieldsArray, includeArray, typeDescriptionArray};
    }

    private static BArray getInnerFieldsArray(Type type) {
        RecordType recordType = type.getTag() == 24 ? (RecordType)type : (RecordType)((ReferenceType)type).getReferredType();
        ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
        BArray fieldsArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        Map fieldsMap = recordType.getFields();
        for (Field field : fieldsMap.values()) {
            fieldsArray.append((Object)StringUtils.fromString((String)field.getFieldName()));
        }
        return fieldsArray;
    }

    static Object getFutureResult(BFuture future) {
        while (!future.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return future.getResult();
    }

    static boolean isKnownRecordType(Type ballerinaType) {
        return KNOWN_RECORD_TYPES.contains(Utils.getBTypeName(ballerinaType));
    }

    private static String getBTypeName(Type ballerinaType) {
        if (ballerinaType.getName() == null || ballerinaType.getName().equals("")) {
            return ballerinaType.toString();
        }
        return ballerinaType.getName();
    }

    public static BArray convertToArray(BTypedesc recordType, BArray arr) {
        ArrayType array = TypeCreator.createArrayType((Type)recordType.getDescribingType());
        BArray returnArray = ValueCreator.createArrayValue((ArrayType)array);
        for (Object element : arr.getValues()) {
            if (element == null) break;
            returnArray.append(element);
        }
        return returnArray;
    }
}

