/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.datastore;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.persist.Constants;
import io.ballerina.stdlib.persist.ModuleUtils;
import io.ballerina.stdlib.persist.Utils;

public class MySQLProcessor {
    private MySQLProcessor() {
    }

    public static BStream query(Environment env, BObject client, BTypedesc targetType) {
        BString entity = Utils.getEntity(env);
        BObject persistClient = Utils.getPersistClient(client, entity);
        BArray keyFields = (BArray)persistClient.get(Constants.KEY_FIELDS);
        RecordType recordType = (RecordType)targetType.getDescribingType();
        RecordType recordTypeWithIdFields = Utils.getRecordTypeWithKeyFields(keyFields, recordType);
        BTypedesc targetTypeWithIdFields = ValueCreator.createTypedescValue((Type)recordTypeWithIdFields);
        StreamType streamTypeWithIdFields = TypeCreator.createStreamType((Type)recordTypeWithIdFields, (Type)PredefinedTypes.TYPE_NULL);
        BArray[] metadata = Utils.getMetadata(recordType);
        BArray fields = metadata[0];
        BArray includes = metadata[1];
        BArray typeDescriptions = metadata[2];
        BFuture future = env.getRuntime().invokeMethodAsyncSequentially(persistClient, "runReadQuery", null, null, null, null, (Type)streamTypeWithIdFields, new Object[]{targetTypeWithIdFields, true, fields, true, includes, true});
        BStream sqlStream = (BStream)Utils.getFutureResult(future);
        BObject persistStream = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"PersistStream", (Object[])new Object[]{sqlStream, targetType, fields, includes, typeDescriptions, persistClient, null});
        RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)targetType.getDescribingType());
        return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)persistStream);
    }

    public static Object queryOne(Environment env, BObject client, BArray path, BTypedesc targetType) {
        BString entity = Utils.getEntity(env);
        BObject persistClient = Utils.getPersistClient(client, entity);
        BArray keyFields = (BArray)persistClient.get(Constants.KEY_FIELDS);
        RecordType recordType = (RecordType)targetType.getDescribingType();
        RecordType recordTypeWithIdFields = Utils.getRecordTypeWithKeyFields(keyFields, recordType);
        BTypedesc targetTypeWithIdFields = ValueCreator.createTypedescValue((Type)recordTypeWithIdFields);
        ErrorType persistErrorType = TypeCreator.createErrorType((String)"Error", (Module)ModuleUtils.getModule());
        UnionType unionType = TypeCreator.createUnionType((Type[])new Type[]{recordTypeWithIdFields, persistErrorType});
        BArray[] metadata = Utils.getMetadata(recordType);
        BArray fields = metadata[0];
        BArray includes = metadata[1];
        BArray typeDescriptions = metadata[2];
        Object key = Utils.getKey(env, path);
        BFuture future = env.getRuntime().invokeMethodAsyncSequentially(Utils.getPersistClient(client, entity), "runReadByKeyQuery", null, null, null, null, (Type)unionType, new Object[]{targetType, true, targetTypeWithIdFields, true, key, true, fields, true, includes, true, typeDescriptions, true});
        return Utils.getFutureResult(future);
    }
}

