/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.StringType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.persist.Constants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final List<String> KNOWN_RECORD_TYPES = Arrays.asList("Civil", "Date", "TimeOfDay", "Utc");

    private Utils() {
    }

    public static BString getEntity(Environment env) {
        String entity = env.getFunctionName().split("\\$")[2];
        return StringUtils.fromString((String)entity);
    }

    public static BObject getPersistClient(BObject client, BString entity) {
        BMap persistClients = (BMap)client.get(Constants.PERSIST_CLIENTS);
        return (BObject)persistClients.get((Object)entity);
    }

    public static BArray[] getMetadata(RecordType recordType) {
        ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
        ArrayType typeDescriptionArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANY);
        BArray fieldsArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        BArray includeArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        BArray typeDescriptionArray = ValueCreator.createArrayValue((ArrayType)typeDescriptionArrayType);
        Map fieldsMap = recordType.getFields();
        for (Field field : fieldsMap.values()) {
            Type type = field.getFieldType();
            boolean arrayType = false;
            if (type.getTag() == 32) {
                type = ((ArrayType)type).getElementType();
                arrayType = true;
            }
            if (!(type.getTag() != 24 && type.getTag() != 53 || Utils.isKnownRecordType(type))) {
                String innerFieldName = field.getFieldName();
                includeArray.append((Object)StringUtils.fromString((String)innerFieldName));
                BArray innerFieldsArray = Utils.getInnerFieldsArray(type);
                for (int i = 0; i < innerFieldsArray.size(); ++i) {
                    if (arrayType) {
                        fieldsArray.append((Object)StringUtils.fromString((String)(innerFieldName + "[]." + innerFieldsArray.get((long)i).toString())));
                        continue;
                    }
                    fieldsArray.append((Object)StringUtils.fromString((String)(innerFieldName + "." + innerFieldsArray.get((long)i).toString())));
                }
                if (type.getTag() == 53) {
                    type = ((ReferenceType)type).getReferredType();
                }
                typeDescriptionArray.append((Object)ValueCreator.createTypedescValue((Type)Utils.getRecordTypeWithEnumFieldsReplaced((RecordType)type)));
                continue;
            }
            fieldsArray.append((Object)StringUtils.fromString((String)field.getFieldName()));
        }
        return new BArray[]{fieldsArray, includeArray, typeDescriptionArray};
    }

    private static BArray getInnerFieldsArray(Type type) {
        RecordType recordType = type.getTag() == 24 ? (RecordType)type : (RecordType)((ReferenceType)type).getReferredType();
        ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
        BArray fieldsArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        Map fieldsMap = recordType.getFields();
        for (Field field : fieldsMap.values()) {
            fieldsArray.append((Object)StringUtils.fromString((String)field.getFieldName()));
        }
        return fieldsArray;
    }

    static boolean isKnownRecordType(Type ballerinaType) {
        return KNOWN_RECORD_TYPES.contains(Utils.getBTypeName(ballerinaType));
    }

    private static String getBTypeName(Type ballerinaType) {
        if (ballerinaType.getName() == null || ballerinaType.getName().equals("")) {
            return ballerinaType.toString();
        }
        return ballerinaType.getName();
    }

    public static BArray convertToArray(BTypedesc recordType, BArray arr) {
        ArrayType array = TypeCreator.createArrayType((Type)recordType.getDescribingType());
        BArray returnArray = ValueCreator.createArrayValue((ArrayType)array);
        for (Object element : arr.getValues()) {
            if (element == null) break;
            returnArray.append(element);
        }
        return returnArray;
    }

    public static Object getKey(Environment env, BArray path) {
        Parameter[] pathParams = env.getFunctionPathParameters();
        if (pathParams.length == 1) {
            return path.get(0L);
        }
        BMap keyMap = ValueCreator.createMapValue();
        for (int i = 0; i < pathParams.length; ++i) {
            keyMap.put((Object)StringUtils.fromString((String)pathParams[i].name), path.get((long)i));
        }
        return keyMap;
    }

    public static RecordType getRecordTypeWithKeyFields(BArray keyFields, RecordType recordType) {
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        for (Field field : recordType.getFields().values()) {
            if (Utils.isEnumType(field.getFieldType())) {
                StringType updatedType = PredefinedTypes.TYPE_STRING;
                if (field.getFieldType().isNilable()) {
                    updatedType = TypeCreator.createUnionType(Arrays.asList(PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_NULL));
                }
                fieldsMap.put(field.getFieldName(), TypeCreator.createField((Type)updatedType, (String)field.getFieldName(), (long)0L));
                continue;
            }
            fieldsMap.put(field.getFieldName(), field);
        }
        for (int i = 0; i < keyFields.size(); ++i) {
            String key = keyFields.get((long)i).toString();
            if (fieldsMap.containsKey(key)) continue;
            fieldsMap.put(key, TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)key, (long)0L));
        }
        return TypeCreator.createRecordType((String)"$stream$anon$constraint$", (Module)Constants.BALLERINA_ANNOTATIONS_MODULE, (long)1L, fieldsMap, null, (boolean)true, (int)TypeFlags.asMask((int[])new int[]{2, 4}));
    }

    private static RecordType getRecordTypeWithEnumFieldsReplaced(RecordType recordType) {
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        for (Field field : recordType.getFields().values()) {
            if (Utils.isEnumType(field.getFieldType())) {
                StringType updatedType = PredefinedTypes.TYPE_STRING;
                if (field.getFieldType().isNilable()) {
                    updatedType = TypeCreator.createUnionType(Arrays.asList(PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_NULL));
                }
                fieldsMap.put(field.getFieldName(), TypeCreator.createField((Type)updatedType, (String)field.getFieldName(), (long)0L));
                continue;
            }
            fieldsMap.put(field.getFieldName(), field);
        }
        return TypeCreator.createRecordType((String)recordType.getName(), (Module)recordType.getPkg(), (long)recordType.getFlags(), fieldsMap, (Type)recordType.getRestFieldType(), (boolean)recordType.isSealed(), (int)recordType.getTypeFlags());
    }

    private static boolean isWithinTrxBlock(TransactionResourceManager trxResourceManager) {
        return trxResourceManager.isInTransaction() && trxResourceManager.getCurrentTransactionContext().hasTransactionBlock();
    }

    public static Map<String, Object> getTransactionContextProperties() {
        HashMap<String, TransactionLocalContext> properties = null;
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        if (Utils.isWithinTrxBlock(trxResourceManager)) {
            properties = new HashMap<String, TransactionLocalContext>();
            properties.put("currentTrxContext", trxResourceManager.getCurrentTransactionContext());
        }
        return properties;
    }

    private static boolean isEnumType(Type type) {
        return type.getTag() == 33 && ((UnionType)type).getMemberTypes().stream().allMatch(memberType -> memberType.getTag() == 46 || memberType.getTag() == 14);
    }
}

