/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="lower", namespace="str", description="Converts the capital letters in the input string to the equivalent simple letters.", parameters={@Parameter(name="input.string", description="The input string to convert to the lower case (i.e., equivalent simple letters).", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"input.string"})}, returnAttributes={@ReturnAttribute(description="Returns a string value in lower case by converting the input.string .", type={DataType.STRING})}, examples={@Example(syntax="lower(\"WSO2 cep \")", description="This converts the capital letters in the input.string to the equivalent simple letters. In this scenario, the output is \"wso2 cep \".")})
public class LowerFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to str:lower() function, required 1, but found " + this.attributeExpressionExecutors.length);
        }
        Attribute.Type type = expressionExecutors[0].getReturnType();
        if (type != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for str:lower() function, required " + Attribute.Type.STRING + ", but found " + type.toString());
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        return null;
    }

    protected Object execute(Object o, State state) {
        if (o == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to str:lower() function. The argument cannot be null");
        }
        return o.toString().toLowerCase();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

