/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="reverse", namespace="str", description="Returns the input string in the reverse order character-wise and string-wise.", parameters={@Parameter(name="input.string", description="The input string to be reversed.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"input.string"})}, returnAttributes={@ReturnAttribute(description="Returns the reverse ordered string of `input.string` .", type={DataType.STRING})}, examples={@Example(syntax="reverse(\"Hello World\")", description="This outputs a string value by reversing the incoming `input.string`. In this scenario, the output is \"dlroW olleH\".")})
public class ReverseFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to str:reverse() function. Required 1. Found " + executorsCount);
        }
        Attribute.Type type = expressionExecutors[0].getReturnType();
        if (type != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for str:reverse() function, required " + Attribute.Type.STRING + ", but found " + type.toString());
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        return null;
    }

    protected Object execute(Object o, State state) {
        if (o == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to str:reverse() function. The argument cannot be null");
        }
        StringBuilder sb = new StringBuilder(o.toString()).reverse();
        return sb.toString();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

