/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="unhex", namespace="str", description="Returns a string by converting the hexadecimal characters in the input string.", parameters={@Parameter(name="input.string", description="The hexadecimal input string that needs to be converted to string.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"input.string"})}, returnAttributes={@ReturnAttribute(description="This returns the string value of the hexadecimal value that passed.", type={DataType.STRING})}, examples={@Example(syntax="unhex(\"4d7953514c\")", description="This converts the hexadecimal value to string.")})
public class UnhexFunctionExtension
extends FunctionExecutor {
    protected StateFactory<State> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to math:unhex() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of math:unhex() function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        if (data != null) {
            String inputStr = (String)data;
            StringBuilder stringBuilderOut = new StringBuilder();
            for (int i = 0; i < inputStr.length(); i += 2) {
                String hexValue = inputStr.substring(i, i + 2);
                int decimalValue = Integer.parseInt(hexValue, 16);
                stringBuilderOut.append(Character.toChars(decimalValue));
            }
            return stringBuilderOut.toString();
        }
        throw new SiddhiAppRuntimeException("Input to the math:unhex() function cannot be null");
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }
}

