/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="upper", namespace="str", description="Converts the simple letters in the input string to the equivalent capital/block letters.", parameters={@Parameter(name="input.string", description="The input string that should be converted to the upper case (equivalent capital/block letters).", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"input.string"})}, returnAttributes={@ReturnAttribute(description="This returns a string value in upper case by converting the `input.string`", type={DataType.STRING})}, examples={@Example(syntax="upper(\"Hello World\")", description="This converts the simple letters in the `input.string` to theequivalent capital letters. In this scenario, the output is \"HELLO WORLD\".")})
public class UpperFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;

    protected StateFactory<State> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to str:upper() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for str:upper() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to str:upper() function. The argument cannot be null");
        }
        return data.toString().toUpperCase();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

