/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.performance;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.output.StreamCallback;

public class SimpleFilterMultipleQueryPerformance {
    public static void main(String[] args) throws InterruptedException {
        SiddhiManager siddhiManager = new SiddhiManager();
        String siddhiApp = "define stream cseEventStream (symbol string, price float, volume int, timestamp long);@info(name = 'query1') from cseEventStream[70 > price] select * insert into outputStream ;@info(name = 'query2') from cseEventStream[volume > 90] select * insert into outputStream ;";
        SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
        siddhiAppRuntime.addCallback("outputStream", new StreamCallback(){
            public int eventCount = 0;
            public int timeSpent = 0;
            long startTime = System.currentTimeMillis();

            public void receive(Event[] events) {
                for (Event event : events) {
                    ++this.eventCount;
                    this.timeSpent = (int)((long)this.timeSpent + (System.currentTimeMillis() - (Long)event.getData(3)));
                    if (this.eventCount % 1000000 != 0) continue;
                    System.out.println("Throughput : " + (long)(this.eventCount * 1000) / (System.currentTimeMillis() - this.startTime));
                    System.out.println("Time spent :  " + (double)this.timeSpent * 1.0 / (double)this.eventCount);
                    this.startTime = System.currentTimeMillis();
                    this.eventCount = 0;
                    this.timeSpent = 0;
                }
            }
        });
        InputHandler inputHandler = siddhiAppRuntime.getInputHandler("cseEventStream");
        siddhiAppRuntime.start();
        for (int i = 0; i <= 100; ++i) {
            EventPublisher eventPublisher = new EventPublisher(inputHandler);
            eventPublisher.run();
        }
    }

    static class EventPublisher
    implements Runnable {
        InputHandler inputHandler;

        EventPublisher(InputHandler inputHandler) {
            this.inputHandler = inputHandler;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

