/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sample;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.event.Event;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.util.EventPrinter;
import io.siddhi.sample.util.CustomFunctionExtension;

public class ExtensionSample {
    public static void main(String[] args) throws InterruptedException {
        SiddhiManager siddhiManager = new SiddhiManager();
        siddhiManager.setExtension("custom:plus", CustomFunctionExtension.class);
        String siddhiApp = "define stream StockStream (symbol string, price long, volume long);@info(name = 'query1') from StockStream select symbol , custom:plus(price, volume) as totalCount insert into Output;";
        SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
        siddhiAppRuntime.addCallback("query1", new QueryCallback(){

            public void receive(long timestamp, Event[] inEvents, Event[] removeEvents) {
                EventPrinter.print((long)timestamp, (Event[])inEvents, (Event[])removeEvents);
            }
        });
        InputHandler inputHandler = siddhiAppRuntime.getInputHandler("StockStream");
        siddhiAppRuntime.start();
        inputHandler.send(new Object[]{"IBM", 700L, 100L});
        inputHandler.send(new Object[]{"WSO2", 600L, 200L});
        inputHandler.send(new Object[]{"GOOG", 60L, 200L});
        Thread.sleep(500L);
        siddhiAppRuntime.shutdown();
        siddhiManager.shutdown();
    }
}

