/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sample.util;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;

public class CustomFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            Attribute.Type attributeType = expressionExecutor.getReturnType();
            if (attributeType == Attribute.Type.DOUBLE) {
                this.returnType = attributeType;
                continue;
            }
            if (attributeType == Attribute.Type.STRING || attributeType == Attribute.Type.BOOL) {
                throw new SiddhiAppCreationException("Plus cannot have parameters with types String or Bool");
            }
            this.returnType = Attribute.Type.LONG;
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (this.returnType == Attribute.Type.DOUBLE) {
            double total = 0.0;
            for (Object aObj : data) {
                total += Double.parseDouble(String.valueOf(aObj));
            }
            return total;
        }
        long total = 0L;
        for (Object aObj : data) {
            total += Long.parseLong(String.valueOf(aObj));
        }
        return total;
    }

    protected Object execute(Object data, State state) {
        if (this.returnType == Attribute.Type.DOUBLE) {
            return Double.parseDouble(String.valueOf(data));
        }
        return Long.parseLong(String.valueOf(data));
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

