/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core;

import com.lmax.disruptor.ExceptionHandler;
import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.CannotClearSiddhiAppStateException;
import io.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import io.siddhi.core.exception.DefinitionNotExistException;
import io.siddhi.core.exception.QueryNotExistException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.exception.StoreQueryCreationException;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.query.StoreQueryRuntime;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.InputManager;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceHandlerManager;
import io.siddhi.core.stream.output.StreamCallback;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.stream.output.sink.SinkCallback;
import io.siddhi.core.stream.output.sink.SinkHandlerManager;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.table.record.RecordTableHandlerManager;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.StringUtil;
import io.siddhi.core.util.extension.holder.EternalReferencedHolder;
import io.siddhi.core.util.parser.StoreQueryParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.persistence.util.PersistenceHelper;
import io.siddhi.core.util.snapshot.PersistenceReference;
import io.siddhi.core.util.snapshot.Snapshotable;
import io.siddhi.core.util.statistics.BufferedEventsTracker;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.MemoryUsageTracker;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.exception.SiddhiAppContextException;
import io.siddhi.query.api.execution.query.StoreQuery;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SiddhiAppRuntime {
    private static final Logger log = Logger.getLogger(SiddhiAppRuntime.class);
    private final Map<String, Window> windowMap;
    private final Map<String, List<Source>> sourceMap;
    private final Map<String, List<Sink>> sinkMap;
    private ConcurrentMap<String, AggregationRuntime> aggregationMap;
    private Map<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> windowDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> aggregationDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private InputManager inputManager;
    private Map<String, QueryRuntime> queryProcessorMap = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private Map<String, Table> tableMap = new ConcurrentHashMap<String, Table>();
    private Map<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private LinkedHashMap<StoreQuery, StoreQueryRuntime> storeQueryRuntimeMap = new LinkedHashMap();
    private SiddhiAppContext siddhiAppContext;
    private Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap;
    private MemoryUsageTracker memoryUsageTracker;
    private BufferedEventsTracker bufferedEventsTracker;
    private LatencyTracker storeQueryLatencyTracker;
    private SiddhiDebugger siddhiDebugger;
    private boolean running = false;
    private boolean runningWithoutSources = false;
    private Future futureIncrementalPersistor;
    private boolean incrementalDataPurging = true;

    public SiddhiAppRuntime(Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, InputManager inputManager, Map<String, QueryRuntime> queryProcessorMap, Map<String, StreamJunction> streamJunctionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, ConcurrentMap<String, AggregationRuntime> aggregationMap, Map<String, List<Source>> sourceMap, Map<String, List<Sink>> sinkMap, Map<String, PartitionRuntime> partitionMap, SiddhiAppContext siddhiAppContext, Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap) {
        this.streamDefinitionMap = streamDefinitionMap;
        this.tableDefinitionMap = tableDefinitionMap;
        this.windowDefinitionMap = windowDefinitionMap;
        this.aggregationDefinitionMap = aggregationDefinitionMap;
        this.inputManager = inputManager;
        this.queryProcessorMap = queryProcessorMap;
        this.streamJunctionMap = streamJunctionMap;
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.sourceMap = sourceMap;
        this.sinkMap = sinkMap;
        this.partitionMap = partitionMap;
        this.siddhiAppContext = siddhiAppContext;
        this.siddhiAppRuntimeMap = siddhiAppRuntimeMap;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.monitorQueryMemoryUsage();
            this.monitorBufferedEvents();
            this.storeQueryLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, "query", "StoreQueries", null);
        }
        for (Map.Entry<String, List<Sink>> entry : sinkMap.entrySet()) {
            this.addCallback(entry.getKey(), new SinkCallback(entry.getValue(), streamDefinitionMap.get(entry.getKey())));
        }
        for (Map.Entry<String, List<Snapshotable>> entry : sourceMap.entrySet()) {
            InputHandler inputHandler = this.getInputHandler(entry.getKey());
            for (Source source : entry.getValue()) {
                source.getMapper().setInputHandler(inputHandler);
            }
        }
    }

    public String getName() {
        return this.siddhiAppContext.getName();
    }

    public Map<String, StreamDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (StreamDefinition)e.getValue()));
    }

    public Map<String, TableDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (TableDefinition)e.getValue()));
    }

    public Map<String, WindowDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (WindowDefinition)e.getValue()));
    }

    public Map<String, AggregationDefinition> getAggregationDefinitionMap() {
        return this.aggregationDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (AggregationDefinition)e.getValue()));
    }

    public Set<String> getQueryNames() {
        return this.queryProcessorMap.keySet();
    }

    public Map<String, Map<String, AbstractDefinition>> getPartitionedInnerStreamDefinitionMap() {
        HashMap<String, Map<String, AbstractDefinition>> innerStreams = new HashMap<String, Map<String, AbstractDefinition>>();
        for (PartitionRuntime partition : this.partitionMap.values()) {
            innerStreams.put(partition.getElementId(), partition.getLocalStreamDefinitionMap());
        }
        return innerStreams;
    }

    public void addCallback(String streamId, StreamCallback streamCallback) {
        streamCallback.setStreamId(streamId);
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("No stream found with name: " + streamId);
        }
        streamCallback.setStreamDefinition(this.streamDefinitionMap.get(streamId));
        streamCallback.setContext(this.siddhiAppContext);
        streamJunction.subscribe(streamCallback);
    }

    public void addCallback(String queryName, QueryCallback callback) {
        callback.setContext(this.siddhiAppContext);
        QueryRuntime queryRuntime = this.queryProcessorMap.get(queryName);
        if (queryRuntime == null) {
            throw new QueryNotExistException("No query found with name: " + queryName);
        }
        callback.setQuery(queryRuntime.getQuery());
        queryRuntime.addCallback(callback);
    }

    public Event[] query(String storeQuery) {
        return this.query(SiddhiCompiler.parseStoreQuery((String)storeQuery), storeQuery);
    }

    public Event[] query(StoreQuery storeQuery) {
        return this.query(storeQuery, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event[] query(StoreQuery storeQuery, String storeQueryString) {
        try {
            if (this.siddhiAppContext.isStatsEnabled() && this.storeQueryLatencyTracker != null) {
                this.storeQueryLatencyTracker.markIn();
            }
            Event[] eventArray = this;
            synchronized (this) {
                Iterator<Map.Entry<StoreQuery, StoreQueryRuntime>> i;
                StoreQueryRuntime storeQueryRuntime = (StoreQueryRuntime)this.storeQueryRuntimeMap.remove(storeQuery);
                if (storeQueryRuntime == null) {
                    storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                } else {
                    storeQueryRuntime.reset();
                }
                this.storeQueryRuntimeMap.put(storeQuery, storeQueryRuntime);
                if (this.storeQueryRuntimeMap.size() > 50 && (i = this.storeQueryRuntimeMap.entrySet().iterator()).hasNext()) {
                    i.next();
                    i.remove();
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                eventArray = storeQueryRuntime.execute();
                return eventArray;
            }
        }
        catch (RuntimeException e) {
            if (e instanceof SiddhiAppContextException) {
                throw new StoreQueryCreationException(((SiddhiAppContextException)e).getMessageWithOutContext(), e, ((SiddhiAppContextException)e).getQueryContextStartIndex(), ((SiddhiAppContextException)e).getQueryContextEndIndex(), null, storeQueryString);
            }
            throw new StoreQueryCreationException(e.getMessage(), e);
        }
        finally {
            if (this.siddhiAppContext.isStatsEnabled() && this.storeQueryLatencyTracker != null) {
                this.storeQueryLatencyTracker.markOut();
            }
        }
    }

    public Attribute[] getStoreQueryOutputAttributes(String storeQuery) {
        return this.getStoreQueryOutputAttributes(SiddhiCompiler.parseStoreQuery((String)storeQuery), storeQuery);
    }

    public Attribute[] getStoreQueryOutputAttributes(StoreQuery storeQuery) {
        return this.getStoreQueryOutputAttributes(storeQuery, null);
    }

    private Attribute[] getStoreQueryOutputAttributes(StoreQuery storeQuery, String storeQueryString) {
        try {
            StoreQueryRuntime storeQueryRuntime = this.storeQueryRuntimeMap.get(storeQuery);
            if (storeQueryRuntime == null) {
                storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                this.storeQueryRuntimeMap.put(storeQuery, storeQueryRuntime);
            }
            return storeQueryRuntime.getStoreQueryOutputAttributes();
        }
        catch (RuntimeException e) {
            if (e instanceof SiddhiAppContextException) {
                throw new StoreQueryCreationException(((SiddhiAppContextException)e).getMessageWithOutContext(), e, ((SiddhiAppContextException)e).getQueryContextStartIndex(), ((SiddhiAppContextException)e).getQueryContextEndIndex(), null, this.siddhiAppContext.getSiddhiAppString());
            }
            throw new StoreQueryCreationException(e.getMessage(), e);
        }
    }

    public InputHandler getInputHandler(String streamId) {
        return this.inputManager.getInputHandler(streamId);
    }

    public Collection<List<Source>> getSources() {
        return this.sourceMap.values();
    }

    public Collection<List<Sink>> getSinks() {
        return this.sinkMap.values();
    }

    public Collection<Table> getTables() {
        return this.tableMap.values();
    }

    public synchronized void start() {
        if (this.running) {
            log.warn((Object)("Error calling start() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started."));
            return;
        }
        if (!this.runningWithoutSources) {
            this.startWithoutSources();
        }
        if (this.runningWithoutSources) {
            this.startSources();
        }
    }

    public synchronized void startWithoutSources() {
        if (this.running || this.runningWithoutSources) {
            log.warn((Object)("Error calling startWithoutSources() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started."));
        } else {
            try {
                if (this.siddhiAppContext.isStatsEnabled() && this.siddhiAppContext.getStatisticsManager() != null) {
                    this.siddhiAppContext.getStatisticsManager().startReporting();
                }
                for (EternalReferencedHolder eternalReferencedHolder : this.siddhiAppContext.getEternalReferencedHolders()) {
                    eternalReferencedHolder.start();
                }
                for (List list : this.sinkMap.values()) {
                    for (Sink sink : list) {
                        sink.connectWithRetry();
                    }
                }
                for (Table table : this.tableMap.values()) {
                    table.connectWithRetry();
                }
                for (StreamJunction streamJunction : this.streamJunctionMap.values()) {
                    streamJunction.startProcessing();
                }
                if (this.incrementalDataPurging) {
                    for (AggregationRuntime aggregationRuntime : this.aggregationMap.values()) {
                        aggregationRuntime.startPurging();
                    }
                }
                this.runningWithoutSources = true;
            }
            catch (Throwable t) {
                log.error((Object)("Error starting Siddhi App '" + this.siddhiAppContext.getName() + "', triggering shutdown process. " + t.getMessage()));
                try {
                    this.shutdown();
                }
                catch (Throwable throwable) {
                    log.error((Object)("Error shutting down partially started Siddhi App '" + this.siddhiAppContext.getName() + "', " + throwable.getMessage()));
                }
            }
        }
    }

    public void setPurgingEnabled(boolean purgingEnabled) {
        this.incrementalDataPurging = purgingEnabled;
    }

    public synchronized void startSources() {
        if (this.running) {
            log.warn((Object)("Error calling startSources() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started with the sources."));
            return;
        }
        if (!this.runningWithoutSources) {
            throw new SiddhiAppRuntimeException("Cannot call startSources() without calling startWithoutSources() for Siddhi App '" + this.siddhiAppContext.getName() + "'");
        }
        try {
            for (List<Source> sources : this.sourceMap.values()) {
                for (Source source : sources) {
                    source.connectWithRetry();
                }
            }
            this.running = true;
            this.runningWithoutSources = false;
        }
        catch (Throwable t) {
            log.error((Object)("Error starting Siddhi App '" + this.siddhiAppContext.getName() + "', triggering shutdown process. " + t.getMessage()));
            try {
                this.shutdown();
            }
            catch (Throwable t1) {
                log.error((Object)("Error shutting down partially started Siddhi App '" + this.siddhiAppContext.getName() + "', " + t1.getMessage()));
            }
        }
    }

    public synchronized void shutdown() {
        SourceHandlerManager sourceHandlerManager = this.siddhiAppContext.getSiddhiContext().getSourceHandlerManager();
        for (List<Source> list : this.sourceMap.values()) {
            for (Source source : list) {
                try {
                    if (sourceHandlerManager != null) {
                        sourceHandlerManager.unregisterSourceHandler(source.getMapper().getHandler().getElementId());
                    }
                    source.shutdown();
                }
                catch (Throwable t) {
                    log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down source '" + StringUtil.removeCRLFCharacters(source.getType()) + "' at '" + StringUtil.removeCRLFCharacters(source.getStreamDefinition().getId()) + "' on Siddhi App '" + this.siddhiAppContext.getName() + "'."), t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            try {
                table.shutdown();
            }
            catch (Throwable throwable) {
                log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error in shutting down table '" + StringUtil.removeCRLFCharacters(table.getTableDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), throwable);
            }
        }
        SinkHandlerManager sinkHandlerManager = this.siddhiAppContext.getSiddhiContext().getSinkHandlerManager();
        for (List<Sink> list : this.sinkMap.values()) {
            for (Sink sink : list) {
                try {
                    if (sinkHandlerManager != null) {
                        sinkHandlerManager.unregisterSinkHandler(sink.getHandler().getElementId());
                    }
                    sink.shutdown();
                }
                catch (Throwable t) {
                    log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down sink '" + StringUtil.removeCRLFCharacters(sink.getType()) + "' at '" + StringUtil.removeCRLFCharacters(sink.getStreamDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            RecordTableHandlerManager recordTableHandlerManager = this.siddhiAppContext.getSiddhiContext().getRecordTableHandlerManager();
            if (recordTableHandlerManager != null) {
                String elementId = null;
                RecordTableHandler recordTableHandler = table.getHandler();
                if (recordTableHandler != null) {
                    elementId = recordTableHandler.getElementId();
                }
                if (elementId != null) {
                    recordTableHandlerManager.unregisterRecordTableHandler(elementId);
                }
            }
            table.shutdown();
        }
        for (EternalReferencedHolder eternalReferencedHolder : this.siddhiAppContext.getEternalReferencedHolders()) {
            try {
                eternalReferencedHolder.stop();
            }
            catch (Throwable throwable) {
                log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error while stopping EternalReferencedHolder '" + StringUtil.removeCRLFCharacters(eternalReferencedHolder.toString()) + "' down Siddhi app '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), throwable);
            }
        }
        this.inputManager.disconnect();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (StreamJunction streamJunction : SiddhiAppRuntime.this.streamJunctionMap.values()) {
                    streamJunction.stopProcessing();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SiddhiAppRuntime.this.siddhiAppContext.getScheduledExecutorService().shutdownNow();
                SiddhiAppRuntime.this.siddhiAppContext.getExecutorService().shutdownNow();
            }
        }, "Siddhi-SiddhiApp-" + this.siddhiAppContext.getName() + "-Shutdown-Cleaner");
        thread.start();
        if (this.siddhiAppRuntimeMap != null) {
            this.siddhiAppRuntimeMap.remove(this.siddhiAppContext.getName());
        }
        if (this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.isStatsEnabled()) {
                this.siddhiAppContext.getStatisticsManager().stopReporting();
            }
            this.siddhiAppContext.getStatisticsManager().cleanup();
        }
        this.running = false;
        this.runningWithoutSources = false;
    }

    public synchronized SiddhiDebugger debug() {
        this.siddhiDebugger = new SiddhiDebugger(this.siddhiAppContext);
        ArrayList<StreamRuntime> streamRuntime = new ArrayList<StreamRuntime>();
        ArrayList<OutputCallback> streamCallbacks = new ArrayList<OutputCallback>();
        for (QueryRuntime queryRuntime : this.queryProcessorMap.values()) {
            streamRuntime.add(queryRuntime.getStreamRuntime());
            streamCallbacks.add(queryRuntime.getOutputCallback());
        }
        for (StreamRuntime streamRuntime1 : streamRuntime) {
            for (SingleStreamRuntime singleStreamRuntime : streamRuntime1.getSingleStreamRuntimes()) {
                singleStreamRuntime.getProcessStreamReceiver().setSiddhiDebugger(this.siddhiDebugger);
            }
        }
        for (OutputCallback callback : streamCallbacks) {
            callback.setSiddhiDebugger(this.siddhiDebugger);
        }
        this.start();
        return this.siddhiDebugger;
    }

    public PersistenceReference persist() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            if (this.siddhiAppContext.getSiddhiContext().getPersistenceStore() != null) {
                PersistenceReference persistenceReference = PersistenceHelper.persist(this.siddhiAppContext.getSnapshotService().fullSnapshot(), this.siddhiAppContext);
                return persistenceReference;
            }
            PersistenceReference persistenceReference = PersistenceHelper.persist(this.siddhiAppContext.getSnapshotService().incrementalSnapshot(), this.siddhiAppContext);
            return persistenceReference;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public byte[] snapshot() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            byte[] byArray = this.siddhiAppContext.getSnapshotService().fullSnapshot();
            return byArray;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public void restore(byte[] snapshot) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().restore(snapshot);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public void restoreRevision(String revision) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().restoreRevision(revision);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public String restoreLastRevision() throws CannotRestoreSiddhiAppStateException {
        String revision;
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            revision = this.siddhiAppContext.getSnapshotService().restoreLastRevision();
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
        return revision;
    }

    public void clearAllRevisions() throws CannotClearSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().clearAllRevisions();
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    private void monitorQueryMemoryUsage() {
        this.memoryUsageTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createMemoryUsageTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, QueryRuntime> entry : this.queryProcessorMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking(entry.getKey(), entry.getValue(), "Queries", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (PartitionRuntime partitionRuntime : this.partitionMap.values()) {
            partitionRuntime.setMemoryUsageTracker(this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.tableMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Tables", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.windowMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Windows", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.aggregationMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Aggregations", this.siddhiAppContext, this.memoryUsageTracker);
        }
    }

    private void monitorBufferedEvents() {
        this.bufferedEventsTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createBufferSizeTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, StreamJunction> entry : this.streamJunctionMap.entrySet()) {
            this.registerForBufferedEvents(entry);
        }
        for (Map.Entry<String, Object> entry : this.partitionMap.entrySet()) {
            ConcurrentMap<String, StreamJunction> streamJunctionMap = ((PartitionRuntime)entry.getValue()).getLocalStreamJunctionMap();
            for (Map.Entry<String, StreamJunction> entry2 : streamJunctionMap.entrySet()) {
                this.registerForBufferedEvents(entry2);
            }
        }
    }

    private void registerForBufferedEvents(Map.Entry<String, StreamJunction> entry) {
        if (entry.getValue().containsBufferedEvents()) {
            String metricName = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + this.getName() + "." + "Siddhi" + "." + "Streams" + "." + entry.getKey() + "." + "size";
            boolean matchExist = false;
            for (String regex : this.siddhiAppContext.getIncludedMetrics()) {
                if (!metricName.matches(regex)) continue;
                matchExist = true;
                break;
            }
            if (matchExist) {
                this.bufferedEventsTracker.registerEventBufferHolder(entry.getValue(), metricName);
            }
        }
    }

    public void handleExceptionWith(ExceptionHandler<Object> exceptionHandler) {
        this.siddhiAppContext.setDisruptorExceptionHandler(exceptionHandler);
    }

    public void handleRuntimeExceptionWith(ExceptionListener exceptionListener) {
        this.siddhiAppContext.setRuntimeExceptionListener(exceptionListener);
    }

    public boolean isStatsEnabled() {
        return this.siddhiAppContext.isStatsEnabled();
    }

    public void enableStats(boolean statsEnabled) {
        this.siddhiAppContext.setStatsEnabled(statsEnabled);
        if (this.running && this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.isStatsEnabled()) {
                this.siddhiAppContext.getStatisticsManager().startReporting();
                log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting started!"));
            } else {
                this.siddhiAppContext.getStatisticsManager().stopReporting();
                log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting stopped!"));
            }
        } else {
            log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting not changed!"));
        }
    }

    public void enablePlayBack(boolean playBackEnabled, Long idleTime, Long incrementInMilliseconds) {
        this.siddhiAppContext.setPlayback(playBackEnabled);
        if (!playBackEnabled) {
            for (Scheduler scheduler : this.siddhiAppContext.getSchedulerList()) {
                scheduler.switchToLiveMode();
            }
        } else {
            if (idleTime != null && incrementInMilliseconds != null) {
                this.siddhiAppContext.getTimestampGenerator().setIdleTime(idleTime);
                this.siddhiAppContext.getTimestampGenerator().setIncrementInMilliseconds(incrementInMilliseconds);
            }
            for (Scheduler scheduler : this.siddhiAppContext.getSchedulerList()) {
                scheduler.switchToPlayBackMode();
            }
        }
    }
}

