/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.BaseIncrementalValueStore;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncrementalExternalTimestampDataAggregator {
    private final GroupByKeyGenerator groupByKeyGenerator;
    private final BaseIncrementalValueStore baseIncrementalValueStore;
    private final Map<String, BaseIncrementalValueStore> baseIncrementalValueGroupByStore;

    public IncrementalExternalTimestampDataAggregator(List<ExpressionExecutor> baseExecutors, GroupByKeyGenerator groupByKeyGenerator, MetaStreamEvent metaStreamEvent, SiddhiAppContext siddhiAppContext, ExpressionExecutor shouldUpdateExpressionExecutor) {
        StreamEventPool streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        List<ExpressionExecutor> expressionExecutorsWithoutTime = baseExecutors.subList(1, baseExecutors.size());
        this.baseIncrementalValueStore = new BaseIncrementalValueStore(-1L, expressionExecutorsWithoutTime, streamEventPool, siddhiAppContext, null, shouldUpdateExpressionExecutor);
        this.baseIncrementalValueGroupByStore = new HashMap<String, BaseIncrementalValueStore>();
        this.groupByKeyGenerator = groupByKeyGenerator;
    }

    public ComplexEventChunk<StreamEvent> aggregateData(ComplexEventChunk<StreamEvent> retrievedData) {
        while (retrievedData.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)retrievedData.next();
            String groupByKey = this.groupByKeyGenerator.constructEventKey(streamEvent);
            BaseIncrementalValueStore baseIncrementalValueStore = this.baseIncrementalValueGroupByStore.computeIfAbsent(groupByKey, k -> this.baseIncrementalValueStore.cloneStore((String)k, -1L));
            this.process(streamEvent, baseIncrementalValueStore);
        }
        return this.createEventChunkFromAggregatedData();
    }

    private void process(StreamEvent streamEvent, BaseIncrementalValueStore baseIncrementalValueStore) {
        List<ExpressionExecutor> expressionExecutors = baseIncrementalValueStore.getExpressionExecutors();
        boolean shouldUpdate = true;
        ExpressionExecutor shouldUpdateExpressionExecutor = baseIncrementalValueStore.getShouldUpdateExpressionExecutor();
        if (shouldUpdateExpressionExecutor != null) {
            shouldUpdate = (Boolean)shouldUpdateExpressionExecutor.execute(streamEvent);
        }
        for (int i = 0; i < expressionExecutors.size(); ++i) {
            ExpressionExecutor expressionExecutor;
            if (shouldUpdate) {
                expressionExecutor = expressionExecutors.get(i);
                baseIncrementalValueStore.setValue(expressionExecutor.execute(streamEvent), i + 1);
                continue;
            }
            expressionExecutor = expressionExecutors.get(i);
            if (expressionExecutor instanceof VariableExpressionExecutor) continue;
            baseIncrementalValueStore.setValue(expressionExecutor.execute(streamEvent), i + 1);
        }
        baseIncrementalValueStore.setProcessed(true);
    }

    private ComplexEventChunk<StreamEvent> createEventChunkFromAggregatedData() {
        ComplexEventChunk<StreamEvent> processedInMemoryEventChunk = new ComplexEventChunk<StreamEvent>(true);
        for (Map.Entry<String, BaseIncrementalValueStore> entryAgainstTime : this.baseIncrementalValueGroupByStore.entrySet()) {
            processedInMemoryEventChunk.add(entryAgainstTime.getValue().createStreamEvent());
        }
        return processedInMemoryEventChunk;
    }
}

