/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream;

import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventPool;

public class StreamEventCloner {
    private final int beforeWindowDataSize;
    private final int onAfterWindowDataSize;
    private final int outputDataSize;
    private final StreamEventPool streamEventPool;

    public StreamEventCloner(MetaStreamEvent metaStreamEvent, StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
        this.beforeWindowDataSize = metaStreamEvent.getBeforeWindowData().size();
        this.onAfterWindowDataSize = metaStreamEvent.getOnAfterWindowData().size();
        this.outputDataSize = metaStreamEvent.getOutputData().size();
    }

    public StreamEvent copyStreamEvent(StreamEvent streamEvent) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        if (this.beforeWindowDataSize > 0) {
            System.arraycopy(streamEvent.getBeforeWindowData(), 0, borrowedEvent.getBeforeWindowData(), 0, this.beforeWindowDataSize);
        }
        if (this.onAfterWindowDataSize > 0) {
            System.arraycopy(streamEvent.getOnAfterWindowData(), 0, borrowedEvent.getOnAfterWindowData(), 0, this.onAfterWindowDataSize);
        }
        if (this.outputDataSize > 0) {
            System.arraycopy(streamEvent.getOutputData(), 0, borrowedEvent.getOutputData(), 0, this.outputDataSize);
        }
        borrowedEvent.setType(streamEvent.getType());
        borrowedEvent.setTimestamp(streamEvent.getTimestamp());
        return borrowedEvent;
    }
}

