/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.event.stream.converter.StreamEventConverterFactory;

public class ConversionStreamEventChunk
extends ComplexEventChunk<StreamEvent> {
    private static final long serialVersionUID = 2754352338846132676L;
    private StreamEventConverter streamEventConverter;
    private StreamEventPool streamEventPool;

    public ConversionStreamEventChunk(MetaStreamEvent metaStreamEvent, StreamEventPool streamEventPool) {
        super(false);
        this.streamEventPool = streamEventPool;
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(metaStreamEvent);
    }

    public ConversionStreamEventChunk(StreamEventConverter streamEventConverter, StreamEventPool streamEventPool) {
        super(false);
        this.streamEventConverter = streamEventConverter;
        this.streamEventPool = streamEventPool;
    }

    public void convertAndAssign(Event event) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertEvent(event, borrowedEvent);
        this.last = this.first = borrowedEvent;
    }

    public void convertAndAssign(long timestamp, Object[] data) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertData(timestamp, data, borrowedEvent);
        this.last = this.first = borrowedEvent;
    }

    public void convertAndAssign(ComplexEvent complexEvent) {
        this.first = this.streamEventPool.borrowEvent();
        this.last = this.convertAllStreamEvents(complexEvent, (StreamEvent)this.first);
    }

    public void convertAndAssign(Event[] events) {
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertEvent(events[0], firstEvent);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertEvent(events[i], nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        this.first = firstEvent;
        this.last = currentEvent;
    }

    public void convertAndAdd(Event event) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertEvent(event, borrowedEvent);
        if (this.first == null) {
            this.last = this.first = borrowedEvent;
        } else {
            ((StreamEvent)this.last).setNext(borrowedEvent);
            this.last = borrowedEvent;
        }
    }

    private StreamEvent convertAllStreamEvents(ComplexEvent complexEvents, StreamEvent firstEvent) {
        this.streamEventConverter.convertComplexEvent(complexEvents, firstEvent);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertComplexEvent(complexEvents, nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return currentEvent;
    }
}

