/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import java.util.List;

public class FaultStreamEventConverter {
    private StreamEventPool streamEventPool;

    public FaultStreamEventConverter(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
    }

    public StreamEvent convert(Event event, Exception e) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.convertEvent(event, borrowedEvent, e);
        return borrowedEvent;
    }

    public StreamEvent convert(long timestamp, Object[] data, Exception e) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.convertData(timestamp, data, borrowedEvent, e);
        return borrowedEvent;
    }

    public StreamEvent convert(ComplexEvent complexEvents, Exception e) {
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.convertComplexEvent(complexEvents, firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.convertComplexEvent(complexEvents, nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    public StreamEvent convert(Event[] events, Exception e) {
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.convertEvent(events[0], firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.convertEvent(events[i], nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    public StreamEvent convert(List<Event> events, Exception e) {
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.convertEvent(events.get(0), firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.size();
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.convertEvent(events.get(i), nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    private void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent borrowedEvent, Exception e) {
        System.arraycopy(data, 0, borrowedEvent.getOutputData(), 0, data.length);
        borrowedEvent.setOutputData(e, data.length);
        borrowedEvent.setType(type);
        borrowedEvent.setTimestamp(timestamp);
    }

    private void convertEvent(Event event, StreamEvent borrowedEvent, Exception e) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, borrowedEvent, e);
    }

    private void convertComplexEvent(ComplexEvent complexEvent, StreamEvent borrowedEvent, Exception e) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), borrowedEvent, e);
    }

    private void convertData(long timeStamp, Object[] data, StreamEvent borrowedEvent, Exception e) {
        this.convertData(timeStamp, data, ComplexEvent.Type.CURRENT, borrowedEvent, e);
    }
}

