/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import java.io.Serializable;
import java.util.List;

public class SimpleStreamEventConverter
implements StreamEventConverter,
Serializable {
    private static final long serialVersionUID = 8941977469225523543L;
    private List<StreamEventConverter.ConversionMapping> conversionMappings;

    public SimpleStreamEventConverter(List<StreamEventConverter.ConversionMapping> conversionMappings) {
        this.conversionMappings = conversionMappings;
    }

    @Override
    public void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent borrowedEvent) {
        for (StreamEventConverter.ConversionMapping element : this.conversionMappings) {
            borrowedEvent.setOutputData(data[element.getFromPosition()], element.getToPosition()[1]);
        }
        borrowedEvent.setType(type);
        borrowedEvent.setTimestamp(timestamp);
    }

    @Override
    public void convertEvent(Event event, StreamEvent borrowedEvent) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, borrowedEvent);
    }

    @Override
    public void convertComplexEvent(ComplexEvent complexEvent, StreamEvent borrowedEvent) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), borrowedEvent);
    }

    @Override
    public void convertData(long timestamp, Object[] data, StreamEvent borrowedEvent) {
        this.convertData(timestamp, data, ComplexEvent.Type.CURRENT, borrowedEvent);
    }
}

