/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.condition;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.query.api.definition.Attribute;

public class BoolConditionExpressionExecutor
extends ConditionExpressionExecutor {
    protected ExpressionExecutor conditionExecutor;

    public BoolConditionExpressionExecutor(ExpressionExecutor conditionExecutor) {
        if (!conditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
            throw new OperationNotSupportedException("Return type of condition executor " + conditionExecutor.toString() + " should be of type BOOL. Actual Type: " + conditionExecutor.getReturnType().toString());
        }
        this.conditionExecutor = conditionExecutor;
    }

    @Override
    public Boolean execute(ComplexEvent event) {
        Object result = this.conditionExecutor.execute(event);
        if (result == null) {
            return Boolean.FALSE;
        }
        return (Boolean)result;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new BoolConditionExpressionExecutor(this.conditionExecutor.cloneExecutor(key));
    }

    @Override
    public void clean() {
        this.conditionExecutor.clean();
    }
}

