/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="cast", namespace="", description="Converts the first parameter according to the cast.to parameter. Incompatible arguments cause Class Cast exceptions if further processed. This function is used with map extension that returns attributes of the object type. You can use this function to cast the object to an accurate and concrete type.", parameters={@Parameter(name="to.be.caster", description="This specifies the attribute to be casted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT}), @Parameter(name="cast.to", description="A string constant parameter expressing the cast to type using one of the following strings values: int, long, float, double, string, bool.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Returned type will be defined by the cast.to string constant value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, examples={@Example(syntax="from fooStream\nselect symbol as name, cast(temp, 'double') as temp\ninsert into barStream;", description="This will cast the fooStream temp field value into 'double' format.")})
public class CastFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to common:cast() function, required 2 parameters, but found " + attributeExpressionExecutors.length);
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new SiddhiAppValidationException("The second argument has to be a string constant specifying one of the supported data types (int, long, float, double, string, bool)");
        }
        String type = attributeExpressionExecutors[1].execute(null).toString();
        if (type.toLowerCase().equals("int")) {
            this.returnType = Attribute.Type.INT;
        } else if (type.toLowerCase().equals("long")) {
            this.returnType = Attribute.Type.LONG;
        } else if (type.toLowerCase().equals("float")) {
            this.returnType = Attribute.Type.FLOAT;
        } else if (type.toLowerCase().equals("double")) {
            this.returnType = Attribute.Type.DOUBLE;
        } else if (type.toLowerCase().equals("bool")) {
            this.returnType = Attribute.Type.BOOL;
        } else if (type.toLowerCase().equals("string")) {
            this.returnType = Attribute.Type.STRING;
        } else {
            throw new SiddhiAppValidationException("Type must be one of int, long, float, double, bool, string");
        }
    }

    @Override
    protected Object execute(Object[] data) {
        if (this.returnType == Attribute.Type.LONG && data[0] instanceof Integer) {
            return ((Integer)data[0]).longValue();
        }
        return data[0];
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

