/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.Snapshotable;
import org.apache.log4j.Logger;

public abstract class FunctionExecutor
implements ExpressionExecutor,
Snapshotable {
    private static final Logger log = Logger.getLogger(FunctionExecutor.class);
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiQueryContext siddhiQueryContext;
    protected String elementId;
    protected String functionId;
    protected ProcessingMode processingMode;
    private ConfigReader configReader;
    private int attributeSize;

    public void initExecutor(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.processingMode = processingMode;
        this.configReader = configReader;
        this.siddhiQueryContext = siddhiQueryContext;
        try {
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            if (this.elementId == null) {
                this.elementId = "FunctionExecutor-" + this.siddhiQueryContext.getSiddhiAppContext().getElementIdGenerator().createNewId();
            }
            this.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().addSnapshotable(siddhiQueryContext.getName(), this);
            this.init(attributeExpressionExecutors, configReader, this.siddhiQueryContext);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        try {
            FunctionExecutor functionExecutor = (FunctionExecutor)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            functionExecutor.elementId = this.elementId + "-" + key;
            functionExecutor.functionId = this.functionId;
            functionExecutor.initExecutor(innerExpressionExecutors, this.processingMode, this.configReader, this.siddhiQueryContext);
            return functionExecutor;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    protected abstract void init(ExpressionExecutor[] var1, ConfigReader var2, SiddhiQueryContext var3);

    @Override
    public Object execute(ComplexEvent event) {
        try {
            switch (this.attributeSize) {
                case 0: {
                    return this.execute((Object)null);
                }
                case 1: {
                    return this.execute(this.attributeExpressionExecutors[0].execute(event));
                }
            }
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            return this.execute(data);
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException(e.getMessage() + ". Exception on class '" + this.getClass().getName() + "'", e);
        }
    }

    protected abstract Object execute(Object[] var1);

    protected abstract Object execute(Object var1);

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            expressionExecutor.clean();
        }
        this.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().removeSnapshotable(this.siddhiQueryContext.getName(), this);
    }
}

