/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="instanceOfString", namespace="", description="Checks whether the parameter is an instance of String or not.", parameters={@Parameter(name="arg", description="The parameter to be checked.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="Returned type will be boolean and true if and only if the input is a instance of String.", type={DataType.BOOL})}, examples={@Example(syntax="from fooStream\nselect instanceOfString(value) as state\ninsert into barStream;", description="This will return true if the value field format is string ex : 'test'."), @Example(syntax="from fooStream\nselect instanceOfString(switchState) as state\ninsert into barStream;", description="if the switchState = true then this will returns false as the value is an instance of the boolean not a string.")})
public class InstanceOfStringFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to instanceOfString() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return data instanceof String;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

