/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.incremental;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

public class IncrementalAggregateBaseTimeFunctionExecutor
extends FunctionExecutor {
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("incrementalAggregator:getAggregationStartTime() function accepts two arguments, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Second argument of incrementalAggregator:getAggregationStartTime() function accepts should be of type 'STRING', but found '" + attributeExpressionExecutors[1].getReturnType() + "'.");
        }
    }

    @Override
    protected Object execute(Object[] data) {
        TimePeriod.Duration duration;
        String durationName;
        long time = (Long)data[0];
        switch (durationName = (String)data[1]) {
            case "SECONDS": {
                duration = TimePeriod.Duration.SECONDS;
                break;
            }
            case "MINUTES": {
                duration = TimePeriod.Duration.MINUTES;
                break;
            }
            case "HOURS": {
                duration = TimePeriod.Duration.HOURS;
                break;
            }
            case "DAYS": {
                duration = TimePeriod.Duration.DAYS;
                break;
            }
            case "MONTHS": {
                duration = TimePeriod.Duration.MONTHS;
                break;
            }
            case "YEARS": {
                duration = TimePeriod.Duration.YEARS;
                break;
            }
            default: {
                throw new SiddhiAppRuntimeException("Duration '" + durationName + "' used for incrementalAggregator:aggregateBaseTime() is invalid.");
            }
        }
        return IncrementalTimeConverterUtil.getStartTimeOfAggregates(time, duration);
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

