/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.incremental;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.executor.incremental.IncrementalTimeGetTimeZone;
import io.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class IncrementalStartTimeEndTimeFunctionExecutor
extends FunctionExecutor {
    private static List<Pattern> getSupportedRegexPatterns(int withinStringLength) {
        ArrayList<Pattern> gmtRegexPatterns = new ArrayList<Pattern>();
        ArrayList<Pattern> nonGmtRegexPatterns = new ArrayList<Pattern>();
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        if (withinStringLength == 19) {
            return gmtRegexPatterns;
        }
        if (withinStringLength == 26) {
            return nonGmtRegexPatterns;
        }
        return null;
    }

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 1) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string values are supported for single within clause but found, " + attributeExpressionExecutors[0].getReturnType());
            }
        } else if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string and long types are supported as first value of within clause");
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string and long types are supported as second value of within clause");
            }
        } else {
            throw new SiddhiAppValidationException("incrementalAggregator:startTimeEndTime() function accepts only one or two arguments, but found " + attributeExpressionExecutors.length);
        }
    }

    @Override
    protected Object execute(Object[] data) {
        long endTime;
        long startTime = data[0] instanceof Long ? (Long)data[0] : IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(data[0].toString());
        if (startTime >= (endTime = data[1] instanceof Long ? (Long)data[1] : IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(data[1].toString()))) {
            throw new SiddhiAppRuntimeException("The start time must be less than the end time in the within clause. However, the given start time is " + startTime + " and given end time is " + endTime + ", in unix time. Hence, start time is not less than end time.");
        }
        return new Long[]{startTime, endTime};
    }

    @Override
    protected Object execute(Object data) {
        return this.getStartTimeEndTime(data.toString().trim());
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }

    private Long[] getStartTimeEndTime(String singleWithinTimeAsString) {
        List<Pattern> supportedPatterns = IncrementalStartTimeEndTimeFunctionExecutor.getSupportedRegexPatterns(singleWithinTimeAsString.length());
        if (supportedPatterns == null) {
            throw new SiddhiAppRuntimeException("Incorrect format provided for within clause. Supported formats for non GMT timezones are <yyyy>-**-** **:**:** <ZZ>, <yyyy>-<MM>-** **:**:** <ZZ>, <yyyy>-<MM>-<dd> **:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:<mm>:** <ZZ>, and <yyyy>-<MM>-<dd> <HH>:<mm>:<ss> <ZZ>. The ISO 8601 UTC offset must be provided for <ZZ> (ex. +05:30, -11:00). For GMT timezone the same formats must be adhered to, without <ZZ>. However the given format is " + singleWithinTimeAsString);
        }
        for (int i = 0; i < TimePeriod.Duration.values().length; ++i) {
            if (!supportedPatterns.get(i).matcher(singleWithinTimeAsString).matches()) continue;
            switch (i) {
                case 0: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString);
                    long endTime = startTime + 1000L;
                    return new Long[]{startTime, endTime};
                }
                case 1: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 60000L;
                    return new Long[]{startTime, endTime};
                }
                case 2: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 3600000L;
                    return new Long[]{startTime, endTime};
                }
                case 3: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 86400000L;
                    return new Long[]{startTime, endTime};
                }
                case 4: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceFirst("\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01 00:00:00"));
                    String timeZone = IncrementalTimeGetTimeZone.getTimeZone(singleWithinTimeAsString.replaceFirst("\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01 00:00:00"));
                    long endTime = IncrementalTimeConverterUtil.getNextEmitTime(startTime, TimePeriod.Duration.MONTHS, timeZone);
                    return new Long[]{startTime, endTime};
                }
                case 5: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceFirst("\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01-01 00:00:00"));
                    String timeZone = IncrementalTimeGetTimeZone.getTimeZone(singleWithinTimeAsString.replaceFirst("\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01-01 00:00:00"));
                    long endTime = IncrementalTimeConverterUtil.getNextEmitTime(startTime, TimePeriod.Duration.YEARS, timeZone);
                    return new Long[]{startTime, endTime};
                }
            }
        }
        throw new SiddhiAppRuntimeException("Incorrect format provided for within clause. Supported formats for non GMT timezones are <yyyy>-**-** **:**:** <ZZ>, <yyyy>-<MM>-** **:**:** <ZZ>, <yyyy>-<MM>-<dd> **:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:<mm>:** <ZZ>, and <yyyy>-<MM>-<dd> <HH>:<mm>:<ss> <ZZ>. The ISO 8601 UTC offset must be provided for <ZZ> (ex. +05:30, -11:00). For GMT timezone the same formats must be adhered to, without <ZZ>. However the given format is " + singleWithinTimeAsString);
    }
}

