/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.math.divide;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.query.api.definition.Attribute;

public class DivideExpressionExecutorDouble
implements ExpressionExecutor {
    private ExpressionExecutor leftExpressionExecutor;
    private ExpressionExecutor rightExpressionExecutor;

    public DivideExpressionExecutorDouble(ExpressionExecutor leftExpressionExecutor, ExpressionExecutor rightExpressionExecutor) {
        this.leftExpressionExecutor = leftExpressionExecutor;
        this.rightExpressionExecutor = rightExpressionExecutor;
    }

    @Override
    public Object execute(ComplexEvent event) {
        Object leftObject = this.leftExpressionExecutor.execute(event);
        Object rightObject = this.rightExpressionExecutor.execute(event);
        if (leftObject == null || rightObject == null) {
            return null;
        }
        double right = ((Number)rightObject).doubleValue();
        if (right == 0.0) {
            return null;
        }
        return ((Number)leftObject).doubleValue() / right;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new DivideExpressionExecutorDouble(this.leftExpressionExecutor.cloneExecutor(key), this.rightExpressionExecutor.cloneExecutor(key));
    }

    @Override
    public void clean() {
        this.leftExpressionExecutor.clean();
        this.rightExpressionExecutor.clean();
    }
}

