/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.math.divide;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.query.api.definition.Attribute;

public class DivideExpressionExecutorFloat
implements ExpressionExecutor {
    private ExpressionExecutor leftExpressionExecutor;
    private ExpressionExecutor rightExpressionExecutor;

    public DivideExpressionExecutorFloat(ExpressionExecutor leftExpressionExecutor, ExpressionExecutor rightExpressionExecutor) {
        this.leftExpressionExecutor = leftExpressionExecutor;
        this.rightExpressionExecutor = rightExpressionExecutor;
    }

    @Override
    public Object execute(ComplexEvent event) {
        Object leftObject = this.leftExpressionExecutor.execute(event);
        Object rightObject = this.rightExpressionExecutor.execute(event);
        if (leftObject == null || rightObject == null) {
            return null;
        }
        float right = ((Number)rightObject).floatValue();
        if (right == 0.0f) {
            return null;
        }
        return Float.valueOf(((Number)leftObject).floatValue() / right);
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.FLOAT;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new DivideExpressionExecutorFloat(this.leftExpressionExecutor.cloneExecutor(key), this.rightExpressionExecutor.cloneExecutor(key));
    }

    @Override
    public void clean() {
        this.leftExpressionExecutor.clean();
        this.rightExpressionExecutor.clean();
    }
}

