/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.partition;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.core.partition.executor.PartitionExecutor;
import io.siddhi.core.partition.executor.RangePartitionExecutor;
import io.siddhi.core.partition.executor.ValuePartitionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.partition.PartitionType;
import io.siddhi.query.api.execution.partition.RangePartitionType;
import io.siddhi.query.api.execution.partition.ValuePartitionType;
import io.siddhi.query.api.execution.query.input.state.CountStateElement;
import io.siddhi.query.api.execution.query.input.state.EveryStateElement;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.state.NextStateElement;
import io.siddhi.query.api.execution.query.input.state.StateElement;
import io.siddhi.query.api.execution.query.input.state.StreamStateElement;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StreamPartitioner {
    private List<List<PartitionExecutor>> partitionExecutorLists = new ArrayList<List<PartitionExecutor>>();

    public StreamPartitioner(InputStream inputStream, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiQueryContext siddhiQueryContext) {
        if (partition != null) {
            this.createExecutors(inputStream, partition, metaEvent, executors, siddhiQueryContext);
        }
    }

    private void createExecutors(InputStream inputStream, Partition partition, MetaComplexEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiQueryContext siddhiQueryContext) {
        if (inputStream instanceof SingleInputStream) {
            if (metaEvent instanceof MetaStateEvent) {
                this.createSingleInputStreamExecutors((SingleInputStream)inputStream, partition, ((MetaStateEvent)metaEvent).getMetaStreamEvent(0), executors, null, siddhiQueryContext);
            } else {
                this.createSingleInputStreamExecutors((SingleInputStream)inputStream, partition, (MetaStreamEvent)metaEvent, executors, null, siddhiQueryContext);
            }
        } else if (inputStream instanceof JoinInputStream) {
            this.createJoinInputStreamExecutors((JoinInputStream)inputStream, partition, (MetaStateEvent)metaEvent, executors, siddhiQueryContext);
        } else if (inputStream instanceof StateInputStream) {
            this.createStateInputStreamExecutors(((StateInputStream)inputStream).getStateElement(), partition, (MetaStateEvent)metaEvent, executors, 0, siddhiQueryContext);
        }
    }

    private int createStateInputStreamExecutors(StateElement stateElement, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, int executorIndex, SiddhiQueryContext siddhiQueryContext) {
        if (stateElement instanceof EveryStateElement) {
            return this.createStateInputStreamExecutors(((EveryStateElement)stateElement).getStateElement(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
        }
        if (stateElement instanceof NextStateElement) {
            executorIndex = this.createStateInputStreamExecutors(((NextStateElement)stateElement).getStateElement(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
            return this.createStateInputStreamExecutors(((NextStateElement)stateElement).getNextStateElement(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
        }
        if (stateElement instanceof LogicalStateElement) {
            executorIndex = this.createStateInputStreamExecutors((StateElement)((LogicalStateElement)stateElement).getStreamStateElement1(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
            return this.createStateInputStreamExecutors((StateElement)((LogicalStateElement)stateElement).getStreamStateElement2(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
        }
        if (stateElement instanceof CountStateElement) {
            return this.createStateInputStreamExecutors((StateElement)((CountStateElement)stateElement).getStreamStateElement(), partition, metaEvent, executors, executorIndex, siddhiQueryContext);
        }
        int size = executors.size();
        this.createExecutors((InputStream)((StreamStateElement)stateElement).getBasicSingleInputStream(), partition, metaEvent.getMetaStreamEvent(executorIndex), executors, siddhiQueryContext);
        for (int j = size; j < executors.size(); ++j) {
            executors.get((int)j).getPosition()[0] = executorIndex;
        }
        return ++executorIndex;
    }

    private void createJoinInputStreamExecutors(JoinInputStream inputStream, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiQueryContext siddhiQueryContext) {
        this.createExecutors(inputStream.getLeftInputStream(), partition, metaEvent.getMetaStreamEvent(0), executors, siddhiQueryContext);
        int size = executors.size();
        for (VariableExpressionExecutor variableExpressionExecutor : executors) {
            variableExpressionExecutor.getPosition()[0] = 0;
        }
        this.createExecutors(inputStream.getRightInputStream(), partition, metaEvent.getMetaStreamEvent(1), executors, siddhiQueryContext);
        for (int i = size; i < executors.size(); ++i) {
            executors.get((int)i).getPosition()[0] = 1;
        }
    }

    private void createSingleInputStreamExecutors(SingleInputStream inputStream, Partition partition, MetaStreamEvent metaEvent, List<VariableExpressionExecutor> executors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ArrayList<PartitionExecutor> executorList = new ArrayList<PartitionExecutor>();
        this.partitionExecutorLists.add(executorList);
        if (!inputStream.isInnerStream()) {
            for (PartitionType partitionType : partition.getPartitionTypeMap().values()) {
                if (partitionType instanceof ValuePartitionType) {
                    if (!partitionType.getStreamId().equals(inputStream.getStreamId())) continue;
                    executorList.add(new ValuePartitionExecutor(ExpressionParser.parseExpression(((ValuePartitionType)partitionType).getExpression(), metaEvent, -1, tableMap, executors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext)));
                    continue;
                }
                for (RangePartitionType.RangePartitionProperty rangePartitionProperty : ((RangePartitionType)partitionType).getRangePartitionProperties()) {
                    if (!partitionType.getStreamId().equals(inputStream.getStreamId())) continue;
                    executorList.add(new RangePartitionExecutor((ConditionExpressionExecutor)ExpressionParser.parseExpression(rangePartitionProperty.getCondition(), metaEvent, -1, tableMap, executors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext), rangePartitionProperty.getPartitionKey()));
                }
            }
        }
    }

    public List<List<PartitionExecutor>> getPartitionExecutorLists() {
        return this.partitionExecutorLists;
    }
}

