/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.join;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventPool;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import java.util.LinkedList;

public class JoinProcessor
implements Processor {
    private boolean trigger;
    private boolean leftJoinProcessor = false;
    private boolean outerJoinProcessor = false;
    private int matchingStreamIndex;
    private boolean preJoinProcessor;
    private StateEventPool stateEventPool;
    private CompiledCondition compiledCondition;
    private FindableProcessor findableProcessor;
    private Processor nextProcessor;
    private QuerySelector selector;

    public JoinProcessor(boolean leftJoinProcessor, boolean preJoinProcessor, boolean outerJoinProcessor, int matchingStreamIndex) {
        this.leftJoinProcessor = leftJoinProcessor;
        this.preJoinProcessor = preJoinProcessor;
        this.outerJoinProcessor = outerJoinProcessor;
        this.matchingStreamIndex = matchingStreamIndex;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (this.trigger) {
            LinkedList returnEventChunkList = new LinkedList();
            StateEvent joinStateEvent = new StateEvent(2, 0);
            StreamEvent nextEvent = (StreamEvent)complexEventChunk.getFirst();
            complexEventChunk.clear();
            while (nextEvent != null) {
                StreamEvent streamEvent = nextEvent;
                nextEvent = streamEvent.getNext();
                streamEvent.setNext(null);
                ComplexEvent.Type type = streamEvent.getType();
                if (type == ComplexEvent.Type.TIMER) continue;
                if (type == ComplexEvent.Type.RESET) {
                    StateEvent outputStateEvent;
                    if (!this.leftJoinProcessor) {
                        outputStateEvent = this.joinEventBuilder(null, streamEvent, type);
                        returnEventChunkList.add(new ComplexEventChunk<StateEvent>(outputStateEvent, outputStateEvent, true));
                        continue;
                    }
                    outputStateEvent = this.joinEventBuilder(streamEvent, null, type);
                    returnEventChunkList.add(new ComplexEventChunk<StateEvent>(outputStateEvent, outputStateEvent, true));
                    continue;
                }
                joinStateEvent.setEvent(this.matchingStreamIndex, streamEvent);
                StreamEvent foundStreamEvent = this.findableProcessor.find(joinStateEvent, this.compiledCondition);
                joinStateEvent.setEvent(this.matchingStreamIndex, null);
                if (foundStreamEvent == null) {
                    StateEvent outputStateEvent;
                    if (this.outerJoinProcessor && !this.leftJoinProcessor) {
                        outputStateEvent = this.joinEventBuilder(null, streamEvent, type);
                        returnEventChunkList.add(new ComplexEventChunk<StateEvent>(outputStateEvent, outputStateEvent, true));
                        continue;
                    }
                    if (!this.outerJoinProcessor || !this.leftJoinProcessor) continue;
                    outputStateEvent = this.joinEventBuilder(streamEvent, null, type);
                    returnEventChunkList.add(new ComplexEventChunk<StateEvent>(outputStateEvent, outputStateEvent, true));
                    continue;
                }
                ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(true);
                while (foundStreamEvent != null) {
                    StreamEvent nextFoundStreamEvent = foundStreamEvent.getNext();
                    foundStreamEvent.setNext(null);
                    if (!this.leftJoinProcessor) {
                        returnEventChunk.add(this.joinEventBuilder(foundStreamEvent, streamEvent, type));
                    } else {
                        returnEventChunk.add(this.joinEventBuilder(streamEvent, foundStreamEvent, type));
                    }
                    foundStreamEvent = nextFoundStreamEvent;
                }
                returnEventChunkList.add(returnEventChunk);
            }
            for (ComplexEventChunk complexEventChunk2 : returnEventChunkList) {
                if (complexEventChunk2.getFirst() == null) continue;
                this.selector.process(complexEventChunk2);
                complexEventChunk2.clear();
            }
        } else if (this.preJoinProcessor) {
            this.nextProcessor.process(complexEventChunk);
        }
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
        if (processor instanceof QuerySelector) {
            this.selector = (QuerySelector)processor;
        }
    }

    @Override
    public Processor cloneProcessor(String key) {
        JoinProcessor joinProcessor = new JoinProcessor(this.leftJoinProcessor, this.preJoinProcessor, this.outerJoinProcessor, this.matchingStreamIndex);
        joinProcessor.setTrigger(this.trigger);
        if (this.trigger) {
            joinProcessor.setCompiledCondition(this.compiledCondition.cloneCompilation(key));
        }
        return joinProcessor;
    }

    @Override
    public void clean() {
    }

    public void setFindableProcessor(FindableProcessor findableProcessor) {
        this.findableProcessor = findableProcessor;
    }

    public CompiledCondition getCompiledCondition() {
        return this.compiledCondition;
    }

    public void setCompiledCondition(CompiledCondition compiledCondition) {
        this.compiledCondition = compiledCondition;
    }

    public void setTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public void setStateEventPool(StateEventPool stateEventPool) {
        this.stateEventPool = stateEventPool;
    }

    public StateEvent joinEventBuilder(StreamEvent leftStream, StreamEvent rightStream, ComplexEvent.Type type) {
        StateEvent returnEvent = this.stateEventPool.borrowEvent();
        returnEvent.setEvent(0, leftStream);
        returnEvent.setEvent(1, rightStream);
        returnEvent.setType(type);
        if (!this.leftJoinProcessor) {
            returnEvent.setTimestamp(rightStream.getTimestamp());
        } else {
            returnEvent.setTimestamp(leftStream.getTimestamp());
        }
        return returnEvent;
    }
}

