/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.join;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.join.JoinProcessor;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.query.processor.stream.window.WindowProcessor;
import java.util.ArrayList;
import java.util.List;

public class JoinStreamRuntime
implements StreamRuntime {
    private List<SingleStreamRuntime> singleStreamRuntimeList = new ArrayList<SingleStreamRuntime>();
    private SiddhiQueryContext siddhiQueryContext;
    private MetaStateEvent metaStateEvent;
    private ProcessingMode overallProcessingMode = ProcessingMode.BATCH;

    public JoinStreamRuntime(SiddhiQueryContext siddhiQueryContext, MetaStateEvent metaStateEvent) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.metaStateEvent = metaStateEvent;
    }

    public void addRuntime(SingleStreamRuntime singleStreamRuntime) {
        this.overallProcessingMode = ProcessingMode.findUpdatedProcessingMode(this.overallProcessingMode, singleStreamRuntime.getProcessingMode());
        this.singleStreamRuntimeList.add(singleStreamRuntime);
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.singleStreamRuntimeList;
    }

    @Override
    public StreamRuntime clone(String key) {
        JoinStreamRuntime joinStreamRuntime = new JoinStreamRuntime(this.siddhiQueryContext, this.metaStateEvent);
        for (SingleStreamRuntime singleStreamRuntime : this.singleStreamRuntimeList) {
            joinStreamRuntime.addRuntime((SingleStreamRuntime)singleStreamRuntime.clone(key));
        }
        SingleStreamRuntime leftSingleStreamRuntime = joinStreamRuntime.getSingleStreamRuntimes().get(0);
        SingleStreamRuntime rightSingleStreamRuntime = joinStreamRuntime.getSingleStreamRuntimes().get(1);
        Processor lastLeftProcessor = leftSingleStreamRuntime.getProcessorChain();
        while (!(lastLeftProcessor instanceof JoinProcessor)) {
            lastLeftProcessor = lastLeftProcessor.getNextProcessor();
        }
        JoinProcessor leftPreJoinProcessor = (JoinProcessor)lastLeftProcessor;
        WindowProcessor leftWindowProcessor = (WindowProcessor)leftPreJoinProcessor.getNextProcessor();
        JoinProcessor leftPostJoinProcessor = (JoinProcessor)leftWindowProcessor.getNextProcessor();
        Processor lastRightProcessor = rightSingleStreamRuntime.getProcessorChain();
        while (!(lastRightProcessor instanceof JoinProcessor)) {
            lastRightProcessor = lastRightProcessor.getNextProcessor();
        }
        JoinProcessor rightPreJoinProcessor = (JoinProcessor)lastRightProcessor;
        WindowProcessor rightWindowProcessor = (WindowProcessor)rightPreJoinProcessor.getNextProcessor();
        JoinProcessor rightPostJoinProcessor = (JoinProcessor)rightWindowProcessor.getNextProcessor();
        rightPostJoinProcessor.setFindableProcessor((FindableProcessor)((Object)leftWindowProcessor));
        rightPreJoinProcessor.setFindableProcessor((FindableProcessor)((Object)leftWindowProcessor));
        leftPreJoinProcessor.setFindableProcessor((FindableProcessor)((Object)rightWindowProcessor));
        leftPostJoinProcessor.setFindableProcessor((FindableProcessor)((Object)rightWindowProcessor));
        return joinStreamRuntime;
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        for (SingleStreamRuntime singleStreamRuntime : this.singleStreamRuntimeList) {
            singleStreamRuntime.setCommonProcessor(commonProcessor);
        }
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }

    @Override
    public ProcessingMode getProcessingMode() {
        return this.overallProcessingMode;
    }
}

