/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.query.input.stream.single.EntryValveProcessor;
import io.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Iterator;

public class AbsentStreamPreStateProcessor
extends StreamPreStateProcessor
implements AbsentPreStateProcessor {
    private Scheduler scheduler;
    private long waitingTime = -1L;
    private long lastScheduledTime;
    private boolean active = true;

    public AbsentStreamPreStateProcessor(StateInputStream.Type stateType, long waitingTime) {
        super(stateType);
        this.waitingTime = waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastArrivalTime(long timestamp) {
        AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
        synchronized (absentStreamPreStateProcessor) {
            this.lastScheduledTime = timestamp + this.waitingTime;
            this.scheduler.notifyAt(this.lastScheduledTime);
        }
    }

    @Override
    public void addState(StateEvent stateEvent) {
        if (!this.active) {
            return;
        }
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                this.newAndEveryStateEventList.clear();
                this.newAndEveryStateEventList.add(stateEvent);
            } else {
                this.newAndEveryStateEventList.add(stateEvent);
            }
            if (!this.isStartState) {
                this.lastScheduledTime = stateEvent.getTimestamp() + this.waitingTime;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
            this.newAndEveryStateEventList.add(clonedEvent);
            this.lastScheduledTime = stateEvent.getTimestamp() + this.waitingTime;
            this.scheduler.notifyAt(this.lastScheduledTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetState() {
        this.lock.lock();
        try {
            this.pendingStateEventList.clear();
            if (this.isStartState) {
                if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).pendingStateEventList.isEmpty()) {
                    return;
                }
                this.init();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (!this.active) {
            return;
        }
        boolean notProcessed = true;
        long currentTime = complexEventChunk.getFirst().getTimestamp();
        ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
        this.lock.lock();
        try {
            boolean initialize;
            boolean bl = initialize = this.isStartState && this.newAndEveryStateEventList.isEmpty() && this.pendingStateEventList.isEmpty();
            if (initialize && this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && this.lastScheduledTime > 0L) {
                initialize = false;
            }
            if (initialize) {
                StateEvent stateEvent = this.stateEventPool.borrowEvent();
                this.addState(stateEvent);
            } else if (this.stateType == StateInputStream.Type.SEQUENCE && !this.newAndEveryStateEventList.isEmpty()) {
                this.resetState();
            }
            this.updateState();
            Iterator iterator = this.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent event = (StateEvent)iterator.next();
                if (this.isExpired(event, currentTime)) {
                    iterator.remove();
                    if (this.withinEveryPreStateProcessor == null || this.thisStatePostProcessor.nextEveryStatePreProcessor == this) continue;
                    this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(event);
                    continue;
                }
                if ((event.getTimestamp() != -1L || currentTime < this.lastScheduledTime) && (event.getTimestamp() == -1L || currentTime < event.getTimestamp() + this.waitingTime)) continue;
                iterator.remove();
                event.setTimestamp(currentTime);
                retEventChunk.add(event);
            }
            if (this.withinEveryPreStateProcessor != null) {
                this.withinEveryPreStateProcessor.updateState();
            }
        }
        finally {
            this.lock.unlock();
        }
        boolean bl = notProcessed = retEventChunk.getFirst() == null;
        while (retEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)retEventChunk.next();
            retEventChunk.remove();
            this.sendEvent(stateEvent);
        }
        long actualCurrentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
        if (actualCurrentTime > this.waitingTime + currentTime) {
            this.lastScheduledTime = actualCurrentTime + this.waitingTime;
        }
        if (notProcessed && this.lastScheduledTime < currentTime) {
            this.lastScheduledTime = currentTime + this.waitingTime;
            this.scheduler.notifyAt(this.lastScheduledTime);
        }
    }

    private void sendEvent(StateEvent stateEvent) {
        if (this.thisStatePostProcessor.nextProcessor != null) {
            this.thisStatePostProcessor.nextProcessor.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
        if (this.thisStatePostProcessor.nextStatePreProcessor != null) {
            this.thisStatePostProcessor.nextStatePreProcessor.addState(stateEvent);
        }
        if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
            this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(stateEvent);
        } else if (this.isStartState) {
            this.active = false;
        }
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
        }
    }

    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        if (!this.active) {
            return new ComplexEventChunk<StateEvent>(false);
        }
        ComplexEventChunk<StateEvent> event = super.processAndReturn(complexEventChunk);
        StateEvent firstEvent = event.getFirst();
        if (firstEvent != null) {
            event = new ComplexEventChunk(false);
        }
        return event;
    }

    @Override
    protected boolean removeOnNoStateChange(StateInputStream.Type stateType) {
        return false;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        AbsentStreamPreStateProcessor streamPreStateProcessor = new AbsentStreamPreStateProcessor(this.stateType, this.waitingTime);
        this.cloneProperties(streamPreStateProcessor, key);
        streamPreStateProcessor.init(this.siddhiQueryContext);
        this.siddhiQueryContext.getSiddhiAppContext().addEternalReferencedHolder(streamPreStateProcessor);
        EntryValveProcessor entryValveProcessor = new EntryValveProcessor(this.siddhiQueryContext.getSiddhiAppContext());
        entryValveProcessor.setToLast(streamPreStateProcessor);
        Scheduler scheduler = SchedulerParser.parse(entryValveProcessor, this.siddhiQueryContext.getSiddhiAppContext());
        streamPreStateProcessor.setScheduler(scheduler);
        return streamPreStateProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStartState && this.waitingTime != -1L && this.active) {
            AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
            synchronized (absentStreamPreStateProcessor) {
                this.lastScheduledTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime() + this.waitingTime;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
    }

    @Override
    public void stop() {
    }
}

